unit Changes;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QComCtrls, QGrids, QDBGrids, QDBCtrls, QStdCtrls, QExtCtrls, DB, DBClient;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    RadioGroup1: TRadioGroup;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    StatusBar1: TStatusBar;
    ClientDataSet1: TClientDataSet;
    DataSource1: TDataSource;
    ClientDataSet1CUST_NO: TIntegerField;
    ClientDataSet1CUSTOMER: TStringField;
    ClientDataSet1CONTACT_FIRST: TStringField;
    ClientDataSet1CONTACT_LAST: TStringField;
    ClientDataSet1PHONE_NO: TStringField;
    ClientDataSet1ADDRESS_LINE1: TStringField;
    ClientDataSet1ADDRESS_LINE2: TStringField;
    ClientDataSet1CITY: TStringField;
    ClientDataSet1STATE_PROVINCE: TStringField;
    ClientDataSet1COUNTRY: TStringField;
    ClientDataSet1POSTAL_CODE: TStringField;
    ClientDataSet1ON_HOLD: TStringField;
    ClientDataSet1Status: TStringField;
    Button1: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RadioGroup1Click(Sender: TObject);
    procedure ClientDataSet1CalcFields(DataSet: TDataSet);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses DataMod;

{$R *.xfm}

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Action := caFree;
end;

procedure TForm2.RadioGroup1Click(Sender: TObject);
begin
case RadioGroup1.ItemIndex of
  0: ClientDataSet1.StatusFilter := [usModified, usInserted, usDeleted];
  1: ClientDataSet1.StatusFilter := [usDeleted];
  2: ClientDataSet1.StatusFilter := [usInserted];
  3: ClientDataSet1.StatusFilter := [usModified];
end;
end;

procedure TForm2.ClientDataSet1CalcFields(DataSet: TDataSet);
begin
case ClientDataSet1.UpdateStatus of
  usModified: ClientDataSet1Status.AsString := 'Modified';
  usInserted: ClientDataSet1Status.AsString := 'Inserted';
  usDeleted: ClientDataSet1Status.AsString := 'Deleted';
  usUnmodified: ClientDataSet1Status.AsString := 'Unmodified';
end;
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
if ClientDataSet1.RecordCount > 0 then
  ClientDataSet1.RevertRecord
else
  ShowMessage('There are no changes in this view to revert');
end;

end.
