unit main;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs, QGrids,
  QDBGrids, QExtCtrls, QDBCtrls, DB, QComCtrls;

type
  TForm1 = class(TForm)
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    StatusBar1: TStatusBar;
    DataSource1: TDataSource;
    procedure DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure DBGrid1EditButtonClick(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure DBGrid1ColEnter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses datmod, empdlg;

{$R *.xfm}

procedure TForm1.DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
  DataSet: TDataSet;
begin
DataSet := DBGrid1.DataSource.DataSet;
if (Column.FieldName = 'PO_NUMBER') and
  (DataSet.FieldByName('ORDER_STATUS').DisplayText = 'waiting') then
  DBGrid1.Canvas.Font.Style := [fsBold];
DBGrid1.DefaultDrawColumnCell(Rect,DataCol,Column,State);
end;

procedure TForm1.DBGrid1EditButtonClick(Sender: TObject);
begin
If DBGrid1.SelectedField.FieldName = 'SALES_REP' then
begin
  with TOKBottomDlg.Create(Self) do
    with DataModule2 do
    begin
      SQLClientDataSet2.Locate('EMP_NO',
        SQLClientDataSet1.FieldByName('SALES_REP').Value,[]);
      try
        if ShowModal = mrOK then
          begin
            SQLClientDataSet1.Edit;
            SQLClientDataSet1.FieldByName('SALES_REP').Value :=
              SQLClientDataSet2.FieldByName('EMP_NO').Value;
          end;
      finally
        Release;
      end;  //try
    end;    //with DataModule2
  end;  //with TOKButtonDlg
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin
  DBGrid1ColEnter(Self);
end;

procedure TForm1.DBGrid1ColEnter(Sender: TObject);
begin
  StatusBar1.SimpleText := DBGrid1.SelectedField.DisplayText;
end;

end.
