unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  IdBaseComponent, IdComponent, IdTCPServer;

type
  TForm1 = class(TForm)
    IdTCPServer1: TIdTCPServer;
    procedure IdTCPServer1Execute(AThread: TIdPeerThread);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses DataMod;

{$R *.xfm}

procedure TForm1.IdTCPServer1Execute(AThread: TIdPeerThread);
var
  cust: Integer;
  DataModule: TDataModule2;
begin
  with AThread.Connection do
  try
    try
      DataModule := TDataModule2.Create(nil);
      try
      cust := StrToIntDef(ReadLn, 0);
      if cust = 0 then
      begin
        WriteLn('Not found');
        Exit;
      end; // if cust = 0
      DataModule.SQLDataSet1.Params[0].Value := cust;
      DataModule.SQLDataSet1.Open;
 //     sleep(5000); //simulate long processing
      if DataModule.SQLDataSet1.IsEmpty then
        WriteLn('Not found.')
      else
        WriteLn(DataModule.SQLDataSet1.Fields[0].AsString +
          ' contact name is '+
          DataModule.SQLDataSet1.Fields[1].AsString + ' ' +
          DataModule.SQLDataSet1.Fields[2].AsString);
    except
      on e: Exception do
      begin
        WriteLn('Error: ' + e.Message);
      end; //on
    end; // try
    finally
      DataModule.Free;
    end; // try
  finally
    Disconnect;
  end; //with try
end;

end.
