unit Threadu;

interface

uses
  Classes, Math, SysUtils, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient;

type
  TTCPClientThread = class(TThread)
  private
    FPort: Integer;
    FHostID: String;
    FCustomerInfo: String;
    { Private declarations }
  protected
    IdTCPClient: TIdTCPClient;
    procedure Execute; override;
    procedure UpdateList;
  public
    destructor Destroy; override;
    property HostID: String read FHostID write FHostID;
    property Port: Integer read FPort write FPort;
  end;

implementation

uses Main;

procedure TTCPClientThread.UpdateList;
begin
  Form1.Memo1.Lines.Add(FCustomerInfo);
end;

procedure TTCPClientThread.Execute;
begin
try
  IdTCPClient := TIdTCPClient.Create(nil);
  IdTCPClient.Host := FHostID;
  IdTCPClient.Port := FPort;
  while True do
  begin
    with IdTCPClient do
    begin
      if Terminated then Exit;
      try
          Connect;
        try
          WriteLn(IntToStr(RandomRange(1001, 1015)));
          if Terminated then Exit;
          FCustomerInfo := ReadLn;
          Synchronize(UpdateList);
        finally
          Disconnect;
        end; // try finally
      except
      end;
      if Terminated then Exit;
      sleep(RandomRange(1,Random(100)));
    end; //with
  end; //while True
except
  Exit;
end;
end;

destructor TTCPClientThread.Destroy;
begin
  if IdTCPClient <> nil then
    IdTCPClient.Free;
  inherited;
end;

initialization
  Randomize;

end.
