unit WebMod;

interface

uses
  Variants, SysUtils, Classes, HTTPApp, DBWeb, DBXpressWeb, DSProd,
  HTTPProd, DBXpress, FMTBcd, DB, SqlExpr;

type
  TWebModule1 = class(TWebModule)
    PageProducer1: TPageProducer;
    DataSetPageProducer1: TDataSetPageProducer;
    SQLQueryTableProducer1: TSQLQueryTableProducer;
    DataSetTableProducer1: TDataSetTableProducer;
    SQLConnection1: TSQLConnection;
    SQLQuery1: TSQLQuery;
    SQLDataSet1: TSQLDataSet;
    SQLDataSet1CUST_NO: TIntegerField;
    SQLDataSet1COUNT: TIntegerField;
    SQLDataSet1MIN: TSQLTimeStampField;
    SQLDataSet1MAX: TSQLTimeStampField;
    SQLDataSet2: TSQLDataSet;
    procedure WebModule1WebActionItem2Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1WebActionItem4Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1WebActionItem3Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure DataSetTableProducer1FormatCell(Sender: TObject; CellRow,
      CellColumn: Integer; var BgColor: THTMLBgColor;
      var Align: THTMLAlign; var VAlign: THTMLVAlign; var CustomAttrs,
      CellData: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses WebReq;

{$R *.xfm}

procedure TWebModule1.WebModule1WebActionItem2Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
//SQLQuery1.ParamByName('CUST_NO').Value := Request.QueryFields.Values['cust'];
//SQLQuery1.Open;
Response.Content := Self.SQLQueryTableProducer1.Content;
//SQLQuery1.Close;
end;

procedure TWebModule1.WebModule1WebActionItem4Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
with TStringList.Create do
try
  Add('<HTML><HEAD><TITLE>DatabaseCGI Demo</TITLE></HEAD>');
  Add('<BODY><H1>Error</H1><P>');
  Add('There is a problem with your request<P>');
  Add('Click here to go to the');
  Add('<A HREF=');
  Add('"http://localhost/cgi-bin/DatabaseCGI/getcustform">');
  Add('customer request form.</A>');
  Response.Content := Text;
finally
  Free;
end;
end;

procedure TWebModule1.WebModule1WebActionItem3Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
SQLDataSet1.ParamByName('cust').AsInteger :=
  StrToInt(Request.QueryFields.Values['cust']);
Response.Content := DataSetPageProducer1.Content;
end;

procedure TWebModule1.DataSetTableProducer1FormatCell(Sender: TObject;
  CellRow, CellColumn: Integer; var BgColor: THTMLBgColor;
  var Align: THTMLAlign; var VAlign: THTMLVAlign; var CustomAttrs,
  CellData: String);
begin
if (CellColumn = 0) and (CellRow > 0) then
begin
  //Create an anchor tag for the customer number field
  CellData := '<A HREF="http://localhost/cgi-bin/DatabaseCGI'+
    '/GetTotal?cust='+CellData+'">'+CellData+'</A>';
end;
end;

initialization
  WebRequestHandler.WebModuleClass := TWebModule1;

end.