unit Updateu;

interface

uses
  Classes, SysUtils, Math;

type
  TUpdateVariable = class(TThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

implementation

uses Main;

{ Important: Methods and properties of objects in CLX can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TUpdateVariable.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TUpdateVariable }

procedure TUpdateVariable.Execute;
begin
while True do
begin
  if Terminated then Exit;
  sleep(RandomRange(1,Random(100)));
  OneCS.Enter;
  try
    GlobalInt := RandomRange(0,MaxInt);
  finally
    OneCS.Leave;
  end;  // try
end; // while
end;

initialization
  Randomize;

end.
 