Unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, SyncObjs;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  OneCS: TCriticalSection;
  GlobalInt: Integer;

implementation

uses Updateu;

{$R *.xfm}

var
  Threads: array [1..5] of TThread;

procedure TForm1.Button1Click(Sender: TObject);
var
  i: Integer;
begin
for i := 1 to 5 do
begin
  Threads[i] := TUpdateVariable.Create(True);
  with Threads[i] do
  begin
    FreeOnTerminate := True;
    Resume;
  end;
end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
OneCS := TCriticalSection.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  i: Integer;
begin
for i := 1 to 5 do
  Threads[i].Terminate;
//give all threads a chance to terminate
sleep(2000);
OneCS.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
OneCS.Enter;
try
  Label1.Caption := IntToStr(GlobalInt);
finally
  OneCS.Leave;
end;
end;

end.
