unit LoadThread;

interface

uses
  Classes, SyncObjs, QDialogs, SysUtils;

type
  TLoader = class(TThread)
  private
    procedure UpdateList;
    { Private declarations }
  protected
    procedure Execute; override;
  public
    WaitForThread: TThread;
  end;

implementation

uses Main, RanThread;

{ Important: Methods and properties of objects in CLX can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TLoader.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TLoader }

threadvar
  currValue: Integer;

procedure TLoader.UpdateList;
var
  i: Integer;
begin
for i := Low(RanGenThread.RandNumbers) to
  High(RanGenThread.RandNumbers) do
  Form1.ListBox1.Items.Add(IntToStr(RanGenThread.RandNumbers[i]));
end;

procedure TLoader.Execute;
begin
if RanEvent.WaitFor(LongWord($FFFFFFFF)) = wrSignaled then
   Synchronize(UpDateList);
end;

end.
