unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  DBXpress, FMTBcd, DBClient, Provider, DB, QGrids, QDBGrids, QExtCtrls,
  QDBCtrls, SqlExpr, QMenus, QTypes;

type
  TForm1 = class(TForm)
    SQLConnection1: TSQLConnection;
    SQLDataSet1: TSQLDataSet;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    DataSetProvider1: TDataSetProvider;
    ClientDataSet1: TClientDataSet;
    MainMenu1: TMainMenu;
    Flie1: TMenuItem;
    Edit1: TMenuItem;
    Exit1: TMenuItem;
    ApplyUpdates1: TMenuItem;
    CancelChangesinChangeLog1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DataSetProvider1BeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure ApplyUpdates1Show(Sender: TObject);
    procedure ApplyUpdates1Click(Sender: TObject);
    procedure CancelChangesinChangeLog1Click(Sender: TObject);
  private
    { Private declarations }
    deleteQuery: TSQLDataSet;
    insertQuery: TSQLDataSet;
    updateQuery: TSQLDataSet;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  deleteQuery := TSQLDataSet.Create(nil);
  with deleteQuery do
  begin
    SQLConnection := SQLConnection1;
    CommandText := 'delete from CUSTOMER '+
                   'where '+
                   'CUST_NO = :OLD_CUST_NO ' +
                   'and CUSTOMER = :OLD_CUSTOMER';
;
  end;
  insertQuery := TSQLDataSet.Create(nil);
  with insertQuery do
  begin
    SQLConnection := SQLConnection1;
    CommandText := 'insert into CUSTOMER '+
                   '(CUST_NO, CUSTOMER) '+
                   'values '+
                   '(:CUST_NO, :CUSTOMER)';
  end;
  updateQuery := TSQLDataSet.Create(nil);
  with updateQuery do
  begin
    SQLConnection := SQLConnection1;
    CommandText := 'update CUSTOMER '+
                   'set CUSTOMER = :CUSTOMER '+
                   'where CUST_NO = :OLD_CUST_NO '+
                   'and CUSTOMER = :OLD_CUSTOMER';
  end;
  deleteQuery.Prepared := True;
  insertQuery.Prepared := True;
  updateQuery.Prepared := True;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  deleteQuery.Prepared := False;
  insertQuery.Prepared := False;
  updateQuery.Prepared := False;
  deleteQuery.Free;
  insertQuery.Free;
  updateQuery.Free;
end;

procedure TForm1.DataSetProvider1BeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
begin
case UpdateKind of
ukModify:
  begin
    updateQuery.ParamByName('CUSTOMER').Value :=
      DeltaDS.FieldByName('CUSTOMER').NewValue;
    updateQuery.ParamByName('OLD_CUSTOMER').Value :=
      DeltaDS.FieldByName('CUSTOMER').OldValue;
    updateQuery.ParamByName('OLD_CUST_NO').Value :=
      DeltaDS.FieldByName('CUST_NO').OldValue;
    updateQuery.ExecSQL;
  end;
ukDelete:
  begin
    deleteQuery.ParamByName('OLD_CUST_NO').Value :=
      DeltaDS.FieldByName('CUST_NO').OldValue;
    deleteQuery.ParamByName('OLD_CUSTOMER').Value :=
      DeltaDS.FieldByName('CUSTOMER').OldValue;
    deleteQuery.ExecSQL;
  end;
ukInsert:
  begin
    insertQuery.ParamByName('CUST_NO').Value :=
      DeltaDS.FieldByName('CUST_NO').NewValue;
    insertQuery.ParamByName('CUSTOMER').Value :=
      DeltaDS.FieldByName('CUSTOMER').NewValue;
    insertQuery.ExecSQL;
  end;
end;
Applied := True;
end;

procedure TForm1.ApplyUpdates1Show(Sender: TObject);
begin
ApplyUpdates1.Enabled :=
  ClientDataSet1.ChangeCount <> 0;
end;

procedure TForm1.ApplyUpdates1Click(Sender: TObject);
begin
ClientDataSet1.ApplyUpdates(-1);
end;

procedure TForm1.CancelChangesinChangeLog1Click(Sender: TObject);
begin
ClientDataSet1.CancelUpdates;
end;

end.
