unit DynMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

type
  TProperCase = procedure (TheString: PChar; 
    const Delimiters: PChar); cdecl;

var
  libHandle: Pointer;
  ProperCase: TProperCase;

(*
The following var block can replace the
preceding type and var blocks
var
  libHandle: Pointer;
  ProperCase: procedure (TheString: PChar;
    const Delimiters: PChar); cdecl;
*)

procedure TForm1.Button1Click(Sender: TObject);
var
  SomeText: PChar;
begin
  libHandle := dlopen('libkylixsotest.so', RTLD_LAZY);
  if Assigned(libHandle) then
  try
    @ProperCase := dlsym(libHandle, 'ProperCase');
    if Assigned(ProperCase) then
      begin
        SomeText := PChar(Memo1.Lines.Text);
        ProperCase(SomeText, ' '#9#10#12);
        Memo1.Lines.Text := SomeText;
        //This next line prevents the library from
        //being closed immediately, so you can see
        //that it is loaded using the Modules window
        ShowMessage('About to close libHandle');
      end; // if
    finally
      dlclose(libHandle);
    end // try
  else
    ShowMessage('Cannot load libkylixsotest.so');
end;


end.
