unit RanThread;

interface

uses
  Classes, Math, SyncObjs;

type
  TRandomizer = class(TThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  public
    ArraySize: Integer;
    RandNumbers: array of Integer;
  end;

implementation

{ Important: Methods and properties of objects in CLX can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TRandomizer.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TRandomizer }

uses Main;

procedure TRandomizer.Execute;
var
  i: Integer;
  LowNum, HighNum: Integer;
  RandNum: Integer;
begin
if ArraySize = 0 then
  begin
    RanEvent.SetEvent;
    Exit;
  end;
SetLength(RandNumbers, ArraySize);
LowNum := Low(RandNumbers);
HighNum := High(RandNumbers);
for i := LowNum to HighNum do
  RandNumbers[i] := -1;
for i := LowNum to HighNum do
  while True do
    begin
       RandNum := RandomRange(LowNum, HighNum);
      if RandNumbers[i] = -1 then
      begin
        RandNumbers[i] := RandNum;
        break;
      end; // if
    end; // while
RanEvent.SetEvent;
end;

end.
