unit main;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QGrids, DB, QDBGrids, QExtCtrls, QComCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    DBGrid1: TDBGrid;
    ListBox1: TListBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses datmod;

{$R *.xfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  CurrentRecord : TBookMark;
  i: Integer;
  DataSet: TDataSet;
begin
  //Update the SelectedRows property
  DBGrid1.SelectedRows.Refresh;
  if DBGrid1.SelectedRows.Count = 0 then
    //Exit if no records are selected
    Exit;

  //Point to the dataset
  DataSet := DBGrid1.DataSource.DataSet;
  //Create a bookmark on the current record
  CurrentRecord := DataSet.GetBookMark;
  DataSet.DisableControls;
  try
    //Clear the ListBox
    ListBox1.Clear;
    //For each of the selected records.
    for i := 0  to DBGrid1.SelectedRows.Count - 1 do
      begin
        //Move to the record
        DataSet.BookMark := DBGrid1.SelectedRows.Items[i];
        //Add the current record's key to the ListBox
        ListBox1.Items.Add(DataSet.FieldByName('PO_NUMBER').AsString);
      end;
  finally
    //Move back to the original current record
    DataSet.GotoBookMark(CurrentRecord);
    //Restore the DataSet
    DataSet.EnableControls;
    //Free the temporary bookmark
    DataSet.FreeBookMark(CurrentRecord);
    StatusBar1.SimpleText := 'Number of records selected = '+
      IntToStr(DBGrid1.SelectedRows.Count);
  end;
end;

end.
