unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QMenus, QTypes, DB, QGrids, QDBGrids, QExtCtrls, QDBCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    View1: TMenuItem;
    Changes1: TMenuItem;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    Edit1: TMenuItem;
    UndoLastChangle1: TMenuItem;
    RestoreCurrentRecord1: TMenuItem;
    Save1: TMenuItem;
    ReverttoSavePoint1: TMenuItem;
    CancelAllChanges1: TMenuItem;
    RecordStatus1: TMenuItem;
    RefreshAllRecords1: TMenuItem;
    DBGrid1: TDBGrid;
    ApplyUpdates1: TMenuItem;
    procedure Changes1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure RecordStatus1Show(Sender: TObject);
    procedure RecordStatus1Click(Sender: TObject);
    procedure RestoreCurrentRecord1Click(Sender: TObject);
    procedure RestoreCurrentRecord1Show(Sender: TObject);
    procedure ReverttoSavePoint1Show(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure ReverttoSavePoint1Click(Sender: TObject);
    procedure CancelAllChanges1Click(Sender: TObject);
    procedure Save1Show(Sender: TObject);
    procedure UndoLastChangle1Click(Sender: TObject);
    procedure RefreshAllRecords1Show(Sender: TObject);
    procedure RefreshAllRecords1Click(Sender: TObject);
    procedure ApplyUpdates1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CurrentSP: Integer;
  end;

var
  Form1: TForm1;

implementation

uses DataMod, Changes;

{$R *.xfm}

procedure TForm1.Changes1Click(Sender: TObject);
begin
  Form2 := TForm2.Create(Self);
  Form2.ClientDataSet1.CloneCursor(DataModule2.SQLClientDataSet1, True, False);
  Form2.ClientDataSet1.StatusFilter := [usModified, usInserted, usDeleted];
  Form2.Show;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
Self.Close;
end;

procedure TForm1.DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
const
  x = 2;
  y = 2;
begin
if  (Column = DBGrid1.Columns[0]) then
  case DataModule2.SQLClientDataSet1.UpdateStatus of
    usModified  : DBGRid1.Canvas.TextOut(Rect.Left + x, Rect.Top + y, 'Modified');
    usDeleted   : DBGRid1.Canvas.TextOut(Rect.Left + x, Rect.Top + y, 'Deleted');
    usInserted  : DBGRid1.Canvas.TextOut(Rect.Left + x, Rect.Top + y, 'Inserted');
    usUnmodified: DBGRid1.Canvas.TextOut(Rect.Left + x, Rect.Top + y, 'Unmodified');
  end;
end;

procedure TForm1.RecordStatus1Show(Sender: TObject);
begin
 RecordStatus1.Checked := DBGrid1.Columns[0].Visible;
end;

procedure TForm1.RecordStatus1Click(Sender: TObject);
begin
  RecordStatus1.Checked := not RecordStatus1.Checked;
  DBGrid1.Columns[0].Visible := RecordStatus1.Checked;
end;

procedure TForm1.RestoreCurrentRecord1Click(Sender: TObject);
begin
 DataModule2.SQLClientDataSet1.RevertRecord;
end;

procedure TForm1.RestoreCurrentRecord1Show(Sender: TObject);
begin
  RestoreCurrentRecord1.Enabled := not (DataModule2.SQLClientDataSet1.UpdateStatus = usUnModified);
end;

procedure TForm1.ReverttoSavePoint1Show(Sender: TObject);
begin
RevertToSavePoint1.Enabled :=  (CurrentSP <> 0) and
  (DataModule2.SQLClientDataSet1.ChangeCount <> 0);
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  CurrentSP := DataModule2.SQLClientDataSet1.SavePoint;
end;

procedure TForm1.ReverttoSavePoint1Click(Sender: TObject);
begin
try
  DataModule2.SQLClientDataSet1.SavePoint := CurrentSP;
except
  CurrentSP := 0;
  ShowMessage('Invalid save point');
end;
end;

procedure TForm1.CancelAllChanges1Click(Sender: TObject);
begin
  DataModule2.SQLClientDataSet1.CancelUpdates;
end;

procedure TForm1.Save1Show(Sender: TObject);
begin
(Sender as TMenuItem).Enabled := (DataModule2.SQLClientDataSet1.ChangeCount <> 0);
end;

procedure TForm1.UndoLastChangle1Click(Sender: TObject);
begin
  DataModule2.SQLClientDataSet1.UndoLastChange(True);
end;

procedure TForm1.RefreshAllRecords1Show(Sender: TObject);
begin
RefreshAllRecords1.Enabled := (DataModule2.SQLClientDataSet1.ChangeCount = 0);
end;

procedure TForm1.RefreshAllRecords1Click(Sender: TObject);
begin
DataModule2.SQLClientDataSet1.Refresh;
end;

procedure TForm1.ApplyUpdates1Click(Sender: TObject);
begin
 DataModule2.SQLClientDataSet1.ApplyUpdates(-1);
end;

end.
