unit main;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QGrids, QMenus, QTypes;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Record1: TMenuItem;
    Add1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1SetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Add1Change(Sender: TObject; Source: TMenuItem;
      Rebuild: Boolean);
    procedure Exit1Change(Sender: TObject; Source: TMenuItem;
      Rebuild: Boolean);
  private
    { Private declarations }
    FDataFile: String;
    FModified: Boolean;
  public
    { Public declarations }
  end;

type
  TCustomer = record
    Name : string[50];
    AccountNo : string[30];
    CreditLimit: Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.FormCreate(Sender: TObject);
var
 cust: TCustomer;
 F : file of TCustomer;
 row: Integer;
begin
  row := 1;
  StringGrid1.RowCount := 2;
  FDataFile := 'custs.dat';
  StringGrid1.Cells[0, 0] := 'Customer Name';
  StringGrid1.ColWidths[0] := 175;
  StringGrid1.Cells[1, 0] := 'Account No';
  StringGrid1.ColWidths[1] := 120;
  StringGrid1.Cells[2, 0] := 'Credit Limit';
  StringGrid1.ColWidths[2] := 80;
  StringGrid1.FixedRows := 1;
  if FileExists(FDataFile) then
  begin
  AssignFile(F,FDataFile);
  Reset(F);
  try
    while not Eof(F) do
    begin
      Read (F, cust);
      StringGrid1.Cells[0, row] := cust.Name;
      StringGrid1.Cells[1, row] := cust.AccountNo;
      StringGrid1.Cells[2, row] := IntToStr(cust.CreditLimit);
      Inc(row);
      StringGrid1.RowCount := row;
    end;
  finally
    CloseFile(F);
  end;
  end;// if FileExists...
end;

procedure TForm1.StringGrid1SetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
if ACol = 2 then
begin
  try
    StrToInt(Value);
  except
    raise Exception.Create('Credit limit must be an integer value');
  end;
end;
FModified := True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Cust: TCustomer;
  F : file of TCustomer;
  row: Integer;
begin
if FModified then
  if MessageDlg('Save Changes',mtConfirmation,mbOkCancel,0) = mrOK then
    begin
      AssignFile(F,'custs.dat');
      Rewrite(F);
      try
        for row := 1 to Pred(StringGrid1.RowCount) do
        begin
        Cust.Name := StringGrid1.Cells[0, row];
        Cust.AccountNo := StringGrid1.Cells[1, row];
        Cust.CreditLimit := StrToInt(StringGrid1.Cells[2, row]);
        Write (F, Cust);
        end;
      finally
        CloseFile(F);
      end;
    end; //if MessageDlg...
end;

procedure TForm1.Add1Change(Sender: TObject; Source: TMenuItem;
  Rebuild: Boolean);
var
  cust: TCustomer;
  row: Integer;
begin
  Cust.name := InputBox('Enter customer name','Name','');
  Cust.AccountNo := InputBox('Enter Account No','Account No','');
  Cust.CreditLimit := StrToInt(InputBox('Enter credit limit','Credit Limit',''));
  row := StringGrid1.RowCount;
  StringGrid1.RowCount := StringGrid1.RowCount + 1;
  StringGrid1.Cells[0, row] := cust.Name;
  StringGrid1.Cells[1, row] := cust.AccountNo;
  StringGrid1.Cells[2, row] := IntToStr(cust.CreditLimit);
  FModified := True;
end;

procedure TForm1.Exit1Change(Sender: TObject; Source: TMenuItem;
  Rebuild: Boolean);
begin
  Self.Close;
end;

end.
