// 
// 
// Opis: Demonstruje uzycie mechanizmu obslugi dziennikow w Linuksie.
// 
//

unit SysLogMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc;

type
  TSysLogMainForm = class(TForm)
    ExitBtn: TButton;
    MonitorGroup: TGroupBox;
    Memo: TMemo;
    NumCharsCombo: TComboBox;
    DisplayBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    EditGroup: TGroupBox;
    EnterBtn: TButton;
    LogEdit: TEdit;
    LogInfoRB: TRadioButton;
    DebugInfoRB: TRadioButton;
    MsgLogRB: TRadioButton;
    DbgLogRB: TRadioButton;
    procedure ExitBtnClick(Sender: TObject);
    procedure DisplayBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure NumCharsComboClick(Sender: TObject);
    procedure EnterBtnClick(Sender: TObject);
    procedure MsgLogRBClick(Sender: TObject);
    procedure DbgLogRBClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
  SYS_MSGS_FNAME = '/var/log/messages';
  SYS_DEBUG_FNAME = '/var/log/debug';
var
  SysLogMainForm: TSysLogMainForm;
  SysMsgFileOK : Boolean;
  CharsToRead : Integer;
  AppName : String;

implementation

{$R *.xfm}

function CanReadSysMsgsFile : Boolean;
var
 FD : Integer;
begin
 FD := open(SYS_MSGS_FNAME, O_RDONLY);
 Result := FD <> -1;
 __close(FD);
end;

procedure TSysLogMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TSysLogMainForm.DisplayBtnClick(Sender: TObject);
var
 FD : Integer;
 Buf : array[0..32768] of Char;
 SR : TSearchRec;
 FSize : Longint;
 s : String;
 MaxChars : Integer;
begin
 Memo.Lines.Clear;

 if MsgLogRB.Checked
  then begin
        FD := open(SYS_MSGS_FNAME, O_RDONLY);
        if FD = -1
         then begin
               ShowMessage('Nie mozna otworzyc systemowego dziennika messages.');
               Exit;
              end;

        FindFirst(SYS_MSGS_FNAME, 0, SR);
       end
  else begin
        FD := open(SYS_DEBUG_FNAME, O_RDONLY);
        if FD = -1
         then begin
               ShowMessage('Nie mozna otworzyc systemowego dziennika debug.');
               Exit;
              end;

        FindFirst(SYS_DEBUG_FNAME, 0, SR);
       end;

 FSize := SR.Size;
 FindClose(SR);

 MaxChars := CharsToRead;
 if MaxChars > FSize then MaxChars := FSize - 1;
 if MaxChars > SizeOf(BUF) then MaxChars := SizeOf(BUF) - 1;
 lseek(FD,FSize - MaxChars, SEEK_SET);
 __read(FD, Buf, MaxChars);
 __close(FD);

 Buf[MaxChars] := chr(0);
 s := StrPas(Buf);
 Memo.Lines.Add(s);
end;

procedure TSysLogMainForm.FormCreate(Sender: TObject);
begin
 AppName := ExtractFileName(Application.ExeName);
 CharsToRead :=
   StrToInt(NumCharsCombo.Items[NumCharsCombo.ItemIndex]);
 SysMsgFileOK := CanReadSysMsgsFile;
 if not SysMsgFileOK
  then begin
        Memo.Enabled := False;
        DisplayBtn.Enabled := False;
        NumCharsCombo.Enabled := False;
        MsgLogRB.Enabled := False;
        DbgLogRb.Enabled := False;
       end;
end;

procedure TSysLogMainForm.NumCharsComboClick(Sender: TObject);
begin
 CharsToRead :=
   StrToInt(NumCharsCombo.Items[NumCharsCombo.ItemIndex]);
end;

procedure TSysLogMainForm.EnterBtnClick(Sender: TObject);
var
 s : String;
begin
 s := LogEdit.Text;
 openlog(PChar(AppName), LOG_PID, LOG_USER);
 if LogInfoRB.Checked
  then syslog(LOG_INFO, PChar(s))
  else syslog(LOG_DEBUG, PChar(s));
 closelog;
 ShowMessage('Komunikat zostal dopisany do systemowego dziennika.');
 LogEdit.Text := ''; 
end;

procedure TSysLogMainForm.MsgLogRBClick(Sender: TObject);
begin
 Memo.Lines.Clear;
end;

procedure TSysLogMainForm.DbgLogRBClick(Sender: TObject);
begin
 Memo.Lines.Clear;
end;

end.
