// 
// 
// Opis: Przekazuje poczte e-mail do programu poczty, 
// uzywajac w tym celu potoku.
// 
//

unit PipeMailMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc;

type
  TPipeMailMainForm = class(TForm)
    Memo: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    RecipientLabel: TLabel;
    SendBtn: TButton;
    ExitBtn: TButton;
    Label3: TLabel;
    Edit: TEdit;
    procedure RefreshDisplay;
    procedure ExitBtnClick(Sender: TObject);
    procedure MemoChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
    procedure EditChange(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF = #10; { linefeed/newline w ASCII  }
 MAILPROG = '/bin/mail'; { lokalizacja pliku poczty }

var
  PipeMailMainForm: TPipeMailMainForm;
  Recipient : String;

implementation

{$R *.xfm}

procedure TPipeMailMainForm.RefreshDisplay;
begin
 SendBtn.Enabled := (Memo.Lines.Count > 0)
  and (Length(Edit.Text) > 0);
end;

procedure TPipeMailMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TPipeMailMainForm.MemoChange(Sender: TObject);
begin
 RefreshDisplay;
end;

procedure TPipeMailMainForm.FormCreate(Sender: TObject);
var
 PPWRec  : PPasswordRecord;
 uid     : Integer;
begin
 uid := getuid;
 PPWRec := getpwuid(uid);
 Recipient := PPWRec^.pw_name;
 RecipientLabel.Caption := Recipient;
end;

procedure TPipeMailMainForm.SendBtnClick(Sender: TObject);
var
 MailFile : PIOFile;
 s : String;
 i : Integer;
begin
 s := MAILPROG + ' -s ''' + Edit.Text + ''' ' + Recipient;
 MailFile := popen(PChar(s), 'w');
 for i := 0 to Memo.Lines.Count - 1 do
   fprintf(MailFile, PChar(Memo.Lines[i] + LF));
 pclose(MailFile);
 ShowMessage('Wyslano wiadomosc do ' + Recipient + '.');
end;

procedure TPipeMailMainForm.EditChange(Sender: TObject);
begin
 RefreshDisplay;
end;

end.
