// 
// 
// Opis: Wyswietla liste aktualnie zalogowanych uzytkownikow.
// 
//

unit LogUserMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc;

type
  TForm1 = class(TForm)
    ExitBtn: TButton;
    Memo: TMemo;
    StartBtn: TButton;
    BasisRBGroup: TRadioGroup;
    Label1: TLabel;
    Label2: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

 
var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.StartBtnClick(Sender: TObject);
var
 PLoginRec : PUserTmp;
 LoginTime : TTime_T;
 s : String;
begin
 if BasisRBGroup.ItemIndex = 0
  then utmpname(_PATH_UTMP) { Biezace logowania }
  else utmpname(_PATH_WTMP); { Poprzednie logowania }

 LoginTime := 0;
 setutent;
 repeat
  PLoginRec := getutent;
  if Assigned(PLoginRec)
   then begin
     if PLoginRec^.ut_type = USER_PROCESS
      then begin
            LoginTime := PLoginRec^.ut_tv.tv_sec;
            s := ctime(@LoginTime);
			{ pomijamy znak nowej linii }
            s := copy(s, 1, Length(s) - 1);
            Memo.Lines.Add(s + '       ' + PLoginRec^.ut_user);
           end;
        end;
 until not Assigned(PLoginRec);
 endutent;
end;

end.
