// 
// 
// Opis: Przekazuje poczte e-mail uzywajac agenta MTA sendmail
// (Mail Transport Agent).
// 
//

unit FileMailMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc, QExtCtrls, QComCtrls;

type
  TFileMailMainForm = class(TForm)
    MsgMemo: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    SendBtn: TButton;
    ExitBtn: TButton;
    Label3: TLabel;
    SubjectEdit: TEdit;
    RecipientsEdit: TEdit;
    StatusBar: TStatusBar;
    procedure SendMail;
    procedure RefreshDisplay;
    procedure ExitBtnClick(Sender: TObject);
    procedure MsgMemoChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
    procedure SubjectEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure RecipientsEditChange(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF = #10; { linefeed/newline w ASCII  }
 SMNumPaths = 3;
 SMSearchPaths : array[1..SMNumPaths] of string
  = ('/usr/lib/sendmail',
     '/usr/sbin/sendmail',
     '/usr/libexec/sendmail');

var
  FileMailMainForm: TFileMailMainForm;
  SMPath : String;
  MailFileName : array[0..128] of Char;
  Recipients : String;
  Subject : String;

implementation

{$R *.xfm}

procedure TFileMailMainForm.SendMail;
var
  i : Integer;
  MailFile : PIOFile;
  Cmd : array[0..512] of Char;
begin
 MailFile := fopen(MailFileName, 'w');
 if not Assigned(MailFile)
  then begin
        ShowMessage('Nie mozna otworzyc tymczasowego pliku poczty!');
        Exit;
       end;

 { zapisujemy informacje dla naglowkow }
 fprintf(MailFile, 'To: %s', Recipients);
 fputc(ord(LF), MailFile);
 fprintf(MailFile, 'Subject: %s', Subject);
 fputc(ord(LF), MailFile);

 { zapisujemy koniec naglowkow }
 fputc(ord(LF), MailFile);

 { zapisujemy wiadomosc }
 for i := 0 to MsgMemo.Lines.Count - 1 do
  begin
   if Length(MsgMemo.Lines[i]) > 0
    then fprintf(MailFile, '%s', MsgMemo.Lines[i]);
   fputc(ord(LF), MailFile);
  end; { for }

 fclose(MailFile);

 { przekazujemy plik do programu sendmail }
 sprintf(Cmd, '%s -oi -t < %s', SMPath, MailFileName);
 if Libc.system(Cmd) <> 0
  then ShowMessage('Wystapil blad podczas przekazywania poczty!')
  else ShowMessage('Wiadomosc zostala wyslana do odbiorcy (odbiorcow).'); 

end;

procedure TFileMailMainForm.RefreshDisplay;
begin
 SendBtn.Enabled := (MsgMemo.Lines.Count > 0)
  and (Length(SubjectEdit.Text) > 0)
  and (Length(RecipientsEdit.Text) > 0);
end;

procedure TFileMailMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TFileMailMainForm.MsgMemoChange(Sender: TObject);
begin
 RefreshDisplay;
end;

procedure TFileMailMainForm.FormCreate(Sender: TObject);
var
 i : Integer;
 SMFound : Boolean;
begin
 { szukamy aplikacji sendmail }
 for i := 1 to SMNumPaths do
  begin
   SMFound := FileExists(SMSearchPaths[i]);
   if SMFound then Break;
  end; { for }

 if SMFound
  then begin
        SMPath := SMSearchPaths[i];
        StatusBar.SimpleText := 'Sendmail znaleziony w ' + SMPath;
       end
  else begin
        RecipientsEdit.Enabled := False;
        SubjectEdit.Enabled := False;
        MsgMemo.Enabled := False;
        StatusBar.SimpleText := 'Nie znaleziono programu sendmail!';
        ShowMessage('Nie znaleziono programu sendmail!');
       end;

 { uzyskujemy unikalna nazwe pliku }
 tmpnam(MailFileName);

end;

procedure TFileMailMainForm.SendBtnClick(Sender: TObject);
begin
 SendMail;
end;

procedure TFileMailMainForm.SubjectEditChange(Sender: TObject);
begin
 Subject := SubjectEdit.Text;
 RefreshDisplay;
end;

procedure TFileMailMainForm.FormDestroy(Sender: TObject);
begin
 if FileExists(MailFileName) then unlink(MailFileName);
end;

procedure TFileMailMainForm.RecipientsEditChange(Sender: TObject);
begin
 Recipients := RecipientsEdit.Text;
 RefreshDisplay;
end;

end.
