// 
// 
// Opis: Demonstruje funkcje systemowe mount oraz umount.
// 
//

unit MountForm;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms,
  QDialogs, Libc, QStdCtrls, TypeSelect;

type
  TForm1 = class(TForm)
  lbFilesystems: TListBox;
  Label1: TLabel;
  btnMount: TButton;
  Label2: TLabel;
  Label3: TLabel;
  Label4: TLabel;
  Label5: TLabel;
  Label8: TLabel;
  lblFsName: TLabel;
  lblMountPoint: TLabel;
  lblFsType: TLabel;
  lblMntOptions: TLabel;
  lblMounted: TLabel;
  btnClose: TButton;
  btnUnmount: TButton;
  procedure FillForm;
  procedure RefreshForm;
  procedure btnUnmountClick(Sender: TObject);
  procedure btnCloseClick(Sender: TObject);
  procedure btnMountClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lbFilesystemsClick(Sender: TObject);
  private
   mounts: TStringList;
   mntEntList: Array [0 .. 49] of
    record
     fsName: String;
     mountPoint: String;
     fstype: String;
     fsOpts: String;
     mounted: boolean;
    end;
  procedure persistMntEntry( idx: Integer; mntEnt: PMountEntry );
  { Deklaracje prywatne }
  public
  { Deklaracje publiczne }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.RefreshForm;
var
 idx: Integer;
begin
 idx := lbFilesystems.ItemIndex;
 lblFsName.Caption := mntEntList[idx].fsName;
 lblMountPoint.Caption := mntEntList[idx].mountPoint;
 lblFsType.Caption := mntEntList[idx].fsType;
 lblMntOptions.Caption := mntEntList[idx].fsOpts;
 if ( mntEntList[idx].mounted )
  then begin
        lblMounted.Caption := 'Tak';
        btnMount.Enabled := false;
        btnUnmount.Enabled := true;
       end
  else begin
	lblMounted.Caption := 'Nie';
	btnMount.Enabled := true;
	btnUnmount.Enabled := false;
       end;
end;

procedure TForm1.FillForm;
var
 f: PIOFile;
 mntEnt: PMountEntry;
 mntIdx: Integer;
begin
 mntIdx := 0;

 if ( getuid <> 0 ) then
  ShowMessage( 'Nie dzialasz jako root.  Bedziesz mogl jedynie ' +
     		 'przegladac informacje montowania, ' +
			 'bez mozliwosci jej zmiany.' );

 // najpierw pobieramy punkty montowania wszystkich
 // zamontowanych dyskow
 f := setmntent( '/proc/mounts', 'r' );
 if not Assigned( f ) then
  begin
   ShowMessage( 'Blad fatalny: Nie mozna otworzyc /proc/mounts' );
   exit;
  end;

 mntEnt := getmntent( f );
 while ( mntEnt <> nil ) do
  begin
   mounts.Add( mntEnt.mnt_dir );
   mntEnt := getmntent( f );
  end;
 endmntent( f );

 // teraz wypelniamy w polu listy liste znanych systemow plikow
 // i zachowujemy je w celu pozniejszego uzycia
 f := setmntent( _PATH_FSTAB, 'r' );
 if ( not Assigned( f ) ) then
  begin
   ShowMessage( 'Blad fatalny: Nie mozna otworzyc ' + _PATH_FSTAB );
   exit;
  end;

 mntEnt := getmntent( f );
 while ( mntEnt <> nil ) do
  begin
   lbFilesystems.Items.Add( mntEnt.mnt_fsname
       + ' (' + mntEnt.mnt_dir + ')' );
   persistMntEntry( mntIdx, mntEnt );

   mntEnt := getmntent( f );

   Inc( mntIdx );
  end;

 endmntent( f );
end;

procedure TForm1.persistMntEntry( idx: Integer; mntEnt: PMountEntry );
begin
 mntEntList[idx].fsName := mntEnt.mnt_fsname;
 mntEntList[idx].mountPoint := mntEnt.mnt_dir;
 mntEntList[idx].fsType := mntEnt.mnt_type;
 mntEntList[idx].fsOpts := mntEnt.mnt_opts;
 if ( mounts.IndexOf( mntEnt.mnt_dir ) <> -1 ) then
  mntEntList[idx].mounted := true
 else
  mntEntList[idx].mounted := false;
end;

procedure TForm1.btnMountClick(Sender: TObject);
var
 idx: Integer;
 rv: Integer;
 str: String;
begin
 idx := lbFilesystems.ItemIndex;
 if ( mntEntList[idx].fstype = 'auto' )
  then begin
 	TTypeSelect.ShowModal;
	str := TTypeSelect.selectedType;
       end
  else
   str := mntEntList[idx].fstype;

 // dla bezpieczenstwa montujmey jako przeznaczony
 // tylko do odczytu
 rv := mount( PChar( mntEntList[idx].fsName ),
	      PChar( mntEntList[idx].mountPoint ),
	      PChar( str ),
	      MS_MGC_VAL Or MS_RDONLY,
	      nil );
 if ( rv <> 0 )
  then ShowMessage( strerror( errno ) )
  else begin
	mntEntList[idx].mounted := true;
        RefreshForm;
	btnMount.Enabled := false;
	btnUnmount.Enabled := true;
       end;
end;

procedure TForm1.btnUnmountClick(Sender: TObject);
var
 idx: Integer;
 rv: Integer;
begin
 idx := lbFilesystems.ItemIndex;
 rv := umount( PChar( mntEntList[idx].fsName ) );
 if ( rv <> 0 )
  then ShowMessage( strerror( errno ) )
  else begin
	mntEntList[idx].mounted := false;
        RefreshForm;
	btnMount.Enabled := true;
	btnUnmount.Enabled := false;
       end;
end;

procedure TForm1.btnCloseClick(Sender: TObject);
begin
 mounts.Free;
 Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 mounts := TStringList.Create;
 FillForm;
end;

procedure TForm1.lbFilesystemsClick(Sender: TObject);
begin
 RefreshForm;
end;

end.
