//
//
// Opis: Ilustruje uzycie kolejek komunikatow
//
//
unit frmDebug;

interface

uses
  SysUtils, Libc, Types, Classes, Variants, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls, QTypes, QExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    FQueueId : Integer;
  public
    { Deklaracje publiczne }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

const
  KeyStr = './dbglog';
  AccessMode = S_IREAD or S_IWRITE or S_IRGRP or S_IWGRP;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FQueueId := msgget (ftok (KeyStr, 1), IPC_CREAT or AccessMode);
  if FQueueID = -1 then
    raise Exception.Create (strerror (errno));
  Timer1.Enabled := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
type
  mqMessage = record
    mtype: LongWord;
    msg: array [0..2000] of char;
  end;

var
  msg: mqMessage;
  len: Integer;

begin
  repeat
    len := msgrcv (FQueueId, msg, sizeof (msg), 0,
      IPC_NOWAIT or MSG_NOERROR);
    if len <> -1 then
      Memo1.Lines.Add (msg.msg);
  until len = -1;
end;

end.
