//
//
// Opis: Ilustruje uzycie kolejek komunikatow
//
//
unit frmClient;

interface

uses
  SysUtils, Libc, Types, Classes, Variants, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls;

type
  TForm2 = class(TForm)
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FQueueId : Integer;
    procedure MsgSend (const msgText: String);
  public
    { Deklaracje publiczne }
  end;

var
  Form2: TForm2;

implementation

{$R *.xfm}

const
  KeyStr = './dbglog';
  AccessMode = S_IREAD or S_IWRITE or S_IRGRP or S_IWGRP;

procedure TForm2.MsgSend (const msgText: String);
type
  mqMessage = record
    mtype: LongWord;
    msg: array [0..200] of char;
  end;

var
  msg: mqMessage;
  len: Integer;
  sMessage: String;

begin
  if FQueueID <> -1 then
  begin
    msg.mtype := 1;
    sMessage := Format ('%d: %s', [getpid, msgText]);
    StrCopy (msg.msg, PChar(sMessage));
    len := sizeof (msg.mtype) + Length(sMessage) + 1;
    msgsnd (FQueueId, msg, len, IPC_NOWAIT);
  end;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  FQueueId := msgget (ftok (KeyStr, 1), IPC_CREAT or AccessMode);
  if FQueueID = -1 then
    raise Exception.Create (strerror (errno));
  MsgSend ('Program uruchomiony');
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
  MsgSend ('Program zatrzymany');
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
  MsgSend ('Uruchamianie funkcji...');
  sleep (1000);
  MsgSend ('...funkcja zakonczona');
end;

end.
