// 
//             FIFO Piping Demo Program 
//            FIFORecvMain.pas : Main Form
//              Developed by Don Taylor 
// 
// Opis: Odczytuje znaki z nazwanego potoku, do ktorego
// wysyla dane program FIFOSender.
// 
//

unit FIFORecvMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, QComCtrls, Libc, QTypes;

type
  TFIFORecvrForm = class(TForm)
    ExitBtn: TButton;
    ReadTypeRBGroup: TRadioGroup;
    StatusBar: TStatusBar;
    FetchBtn: TButton;
    RecvMonitor: TTimer;
    procedure FetchIt;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FetchBtnClick(Sender: TObject);
    procedure RecvMonitorTimer(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 FIFO_Name = '/tmp/FIFODEMO_FIFO';

var
  FIFORecvrForm: TFIFORecvrForm;
  FIFOOpen : Boolean;

implementation

{$R *.xfm}

procedure CreateFIFOIfNecessary;
begin
 FIFOOpen := access(FIFO_Name, F_OK) = 0;
 if not FIFOOpen
  then FIFOOpen := mkfifo(FIFO_Name, 511) = 0; { octal 777 }
end;

procedure TFIFORecvrForm.FetchIt;
var
 FileDesc : Integer;
 BytesRead : Integer;
 TotalBytesRead : Longint;
 Buf : array[0..BUFSIZ] of char;
begin
 if ReadTypeRBGroup.ItemIndex = 0
  then FileDesc := open(FIFO_Name, O_RDONLY)
  else FileDesc := open(FIFO_Name, O_RDONLY or O_NONBLOCK);

  if FileDesc <> -1
   then begin
         TotalBytesRead := 0;
         repeat
          BytesRead := __read(FileDesc, Buf, BUFSIZ);
          TotalBytesRead  := TotalBytesRead + BytesRead;
         until BytesRead = 0;
         __close(FileDesc);
         StatusBar.SimpleText := IntToStr(TotalBytesRead)
           + ' bajtow odczytanych';
        end
   else begin
         MessageDlg('Blad', 'Niemozliwy dostep do potoku FIFO!', mtError,
          [mbOK], 0);
         StatusBar.SimpleText := 'Niemozliwy dostep do potoku FIFO';
        end;

end;

procedure TFIFORecvrForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TFIFORecvrForm.FormCreate(Sender: TObject);
begin
 CreateFIFOIfNecessary;
 StatusBar.SimpleText := 'Gotowy do odbioru';
end;

procedure TFIFORecvrForm.FormActivate(Sender: TObject);
begin
 if not FIFOOpen
  then begin
        FetchBtn.Enabled := False;
        MessageDlg('Blad', 'Potok FIFO nie jest otwarty!',
         mtError, [mbOK], 0);
       end;
end;

procedure TFIFORecvrForm.FetchBtnClick(Sender: TObject);
begin
 FetchBtn.Enabled := False;
 ReadTypeRBGroup.Enabled := False;
 StatusBar.SimpleText := 'Pobieranie danych z potoku FIFO...';
 RecvMonitor.Enabled := True;
end;

procedure TFIFORecvrForm.RecvMonitorTimer(Sender: TObject);
begin
 RecvMonitor.Enabled := False;
 FetchIt;
end;

end.
