//
//
// Opis: Ilustruje zatrzymywanie uruchomionego procesu
//
//
program circ;

uses Libc;

var
  frslt : pid_t;
begin
  frslt := fork();
  if frslt = 0 then
  begin
    // child
    if execl ('circles', nil) = -1 then
      perror ('Blad uruchomienia circles');
  end
  else if frslt < 0 then
    perror ('Blad w fork')
  else
  begin
    // parent
    WriteLn ('Proces potomny uruchomiony: ', frslt);
    WriteLn ('Czekam 10 sekund');
    __sleep (10);  // Czekam 10 sekund
    WriteLn ('Wysylam sygnal TERM do procesu potomnego ', frslt);
    if kill (frslt, SIGTERM) <> 0 then
      perror ('Blad niszczenia procesu');
  end;
end.

