// 
// 
// Opis: prosta aplikacja konsoli demonstrujaca rozgalezienie
// do procesu potomnego i oczekwianie na jego zakonczenie przed
// podjeciem dalszych dzialan.
// 
//

program ForkWait;

{$APPTYPE CONSOLE}

uses
  Libc,
  SysUtils;

var
 forkResult : __pid_t;
 waitResult : __pid_t;

procedure DoChildProcess;
var
 s : String;
begin
 writeln;
 writeln('Proces potomny: ProcessID = ', getpid);
 write('Proces potomny: Wcisnij klawisz [ENTER]...');
 readln(s);
 writeln('Proces potomny: Wyjscie');
end;

begin
 writeln;
 writeln('Proces nadrzedny: ProcessID = ', getpid);
 forkResult := fork;
 case forkResult of
  -1 : writeln('Blad tworzenia procesu potomnego');
   0 : DoChildProcess;
 else begin
       waitResult := waitpid(forkResult, nil, 0);
       if waitResult <> forkResult
        then writeln('Proces nadrzedny: Blad zakonczenia dzialania procesu potomnego')
        else writeln('Proces nadrzedny: Wyjscie');
      end;
 end; { case }
 writeln;
end.
