// 
// 
// Opis: Demonstruje uzycie zewnetrznej wspolnej biblioteki.
// 
//

unit Blowfish;

interface

Const
	BF_ENCRYPT = 1;
	BF_DECRYPT = 0;
	BF_ROUNDS = 16;
	BF_BLOCK = 8;
	BFmodule = 'libblowfish.so.1';

Type
	BF_LONG = LongWord;

	BF_KEY = Record
		P: Array[1 .. BF_ROUNDS + 2] of BF_LONG;
		S: Array[1 .. 1024] of BF_LONG;
	end;
	PBF_KEY = ^BF_KEY;


Procedure BF_set_key( key: PBF_KEY; len: LongInt; data: Pointer ); cdecl;
Procedure BF_ecb_encrypt( input: Pointer; out: Pointer;
						  key: PBF_KEY; enc: LongInt); cdecl;
Procedure BF_cbc_encrypt( input: Pointer; out: Pointer; length: LongInt;
						  ks: PBF_KEY; iv: Pointer; enc: LongInt ); cdecl;
Procedure BF_cfb64_encrypt( input: Pointer; out: Pointer; length: LongInt;
							schedule: PBF_KEY; ivec: Pointer;
							num: PlongInt; enc: LongInt ); cdecl;
Procedure BF_ofb64_encrypt( input: Pointer; out: Pointer; length: LongInt;
							schedule: PBF_KEY; ivec: Pointer;
							num: PLongInt ); cdecl;
Function BF_options: PChar; cdecl;


implementation

procedure BF_set_key;		external BFmodule name 'BF_set_key';
procedure BF_ecb_encrypt;	external BFmodule name 'BF_ecb_encrypt';
procedure BF_cbc_encrypt;	external BFmodule name 'BF_cbc_encrypt';
procedure BF_cfb64_encrypt;	external BFmodule name 'BF_cfb64_encrypt';
procedure BF_ofb64_encrypt; external BFmodule name 'BF_ofb64_encrypt';
function  BF_options;		external BFmodule name 'BF_options';

end.
