//
// Program demonstracyjny wspolnego obiektu
// HelloDynm.pas : Dynamiczny modu interfejsu biblioteki
// Opracowany przez Jima Mischela
//
// Opis: Demonstruje uzycie bibliotek wspolnych plikow.
//
//
unit HelloDynm;

interface

procedure SayHello;

implementation

uses SysUtils, Libc;

const
  STR_LIB_NAME = 'libhello.so.1';
  STR_HELLO_NAME = 'SayHello';

type
  HelloProc = procedure; cdecl;

var
  libHandle : Pointer = nil;

function GetLibraryHandle : Pointer;
begin
  if libHandle = nil then
  begin
    libHandle := dlOpen (STR_LIB_NAME, RTLD_LAZY);
    if libHandle = nil then
      raise Exception.CreateFmt
        ('Nie mozna otworzyc biblioteki "%s"', [STR_LIB_NAME]);
  end;
  Result := libHandle;
end;

function GetLibraryFunction (const fName: String): Pointer;
begin
  Result := dlSym (GetLibraryHandle, PChar(fName));
  if Result = nil then
    raise Exception.CreateFmt
      ('Nie mozna znalezc funkcji "%s" w bibliotece "%s".',
        [STR_LIB_NAME, fName]);
end;

procedure SayHello;
const
  HelloPtr : HelloProc = nil;
begin
  if not Assigned (HelloPtr) then
    HelloPtr := GetLibraryFunction (STR_HELLO_NAME);
  HelloPtr;
end;

initialization


finalization
  if Assigned (libHandle) then
    dlClose (libHandle);

end.

