// 
// 
// Opis: Procedury uzywane przez glowny program.
// 
//

unit CheckMailStuff;

interface

uses
  SysUtils, Libc;

type
 CountType = (MSG_COUNT, MSG_NOCOUNT);

 // Funkcja CheckNewMail zwraca wartosci wskazujace czy uzytkownik
 // o nazwie logName posiada nowe oczekujace wiadomosci. Gdy zostanie
 // wywolana z parametrem opType ustawionym na MSG_COUNT, funkcja
 // zwroci ilosc oczekujacych nowych wiadomosci. Gdy zostanie
 // wywolana z parametrem opType ustawionym na MSG_NOCOUNT, funkcja
 // zwroci wartosc 0 w przypadku gdy nie ma zadnych nowych wiadomosci
 // lub wartosc 1 gdy takie wiadomosci sa obecne. W obu trybach zwrocona
 // wartosc -1 oznacza wystapienie bledu.
 function CheckNewMail(logName: String; opType: CountType): Integer;

implementation
var
 mailFile: String;
 mailCount: Integer;
 new_mailCount: Integer;
 old_mailCount: Integer;
 newMsgs: Integer;
 oldMsgs: Integer;
 lastMTime: Time_T;
 lastSize: Off_T;
 isInternal: boolean;

function isOld( buf: String ): boolean;
begin
 Result := False;
 if ( Pos( 'S', buf ) <> 1 ) and ( Pos( 'X', buf ) <> 1 )
  then Exit;

 // Teraz sprawdzamy status nowej poczty z normalnych klientow...
 if Pos( 'Status:', buf ) = 1
  then begin
   if ( Pos( 'R', buf ) <> 0 ) or ( Pos( 'O', buf ) <> 0 )
    then begin
     Result := True;
     Exit;
    end;
  end;

 // ...i sprawdzamy status nowej poczty z klientow Netscape
 if ( Pos( 'X-Mozilla-Status:', buf ) = 1 )
  and ( Pos( '0000', buf ) = 19 )
   then begin
    Result := True;
    Exit;
   end;

end;


function isFrom( buf: String): boolean;
var
 sender: String;
 dayNum: Integer;

   function GetWord(s : String; idx : Integer) : String;
   var
    i : Integer;
    s1 : String;
    w : String;
   begin
    s1 := s;
    w := '';
    for i := 1 to idx do
     begin
      while (Length(s1) > 0) and (s1[1] in [' ', ^I]) do
       Delete(s1, 1, 1);
      while (Length(s1) > 0) and not (s1[1] in [' ', ^I]) do
       begin
        if i = idx then w := w + s1[1];
        Delete(s1, 1, 1);
       end; { while }
     end; { for }
    Result := w; 
   end;

   function ForceIntConversion(s : String) : Integer;
   var
    i : Integer;
   begin
    if Length(s) > 0
     then begin
           try
            i := StrToInt(s);
           except
            i := 0;
           end; { try }
          end
     else i := 0;
    Result := i;
   end;

begin
 sender := '';
 Result := False;

 // Jesli 5 pierwszych znakow lancucha jest roznych
 // od "From ", zwracamy False
  if Pos( 'From ', buf ) <> 1 then Exit;

 // Sprawdzamy czy brakuje adresu wysylania, przez wyszukanie
 // dnia miesiaca w polu 4 lub 5
 dayNum := ForceIntConversion(GetWord(buf, 4));
 if dayNum = 0
  then begin
        sender := GetWord(buf, 2);
        dayNum := ForceIntConversion(GetWord(buf, 5));
        if (Length(sender) = 0) or (dayNum = 0)
         then Exit;
       end;

 if dayNum > 31 then Exit;

 // Potrzebne dla sprawdzenia "is_Internal" poza ta funkcja.
 // TO JEST EFEKT UBOCZNY.
 if strcmp( PChar( sender), 'MAILER-DAEMON' ) = 0
  then isInternal := True;

 Result := True;

end;

function isMultipartMsg( buf: String;
                         var sepLine: String ): boolean;
var
 idxField: Integer;
 idxSep: Integer;
 lenSep: Integer;
begin
 Result := false;

 // Jesli lancuch nie zaczyna sie od 'Content-Type: ', zwracamy False
 if Pos( 'Content-Type: ', buf ) <> 1 then Exit;

 if Pos( 'multipart/', Copy( buf, 15, 10 ) ) <> 1 then Exit;

 // Zaczynamy od 15-go znaku...
 idxField := 15;

 // ...az do konca lancucha.
 while idxField <= Length( buf ) do
  begin
   // szukamy nastepnego znaku ';'
   while ( idxField <= Length( buf ) )
    and (Copy( buf, idxField, 1 ) <> ';' ) do Inc( idxField );

   if Copy( buf, idxField, 1 ) = ';' then Inc( idxField );

   // szukamy nastepnego znaku nie bedacego spacja
   while ( idxField <= Length( buf ))
    and (Copy( buf, idxField, 1 ) = ' ' ) do Inc( idxField );

   // Jesli w miejscu, w ktorym jestesmy, jest 'boundary='
   if Copy( buf, idxField, 9 ) = 'boundary=' then
    begin
     idxSep := idxField + 9;
     if Copy( buf, idxSep, 1 ) = '"' then
      begin
       Inc( idxSep );
       lenSep := 0;

	   // zliczamy ilosc znakow pomiedzy znakami '"'
       while ( Copy( buf, idxSep + lenSep, 1 ) <> '"' )
        and ( Copy( buf, idxSep + lenSep, 1 ) >= ' ' )
         do Inc( lenSep );
      end
     else
      begin
       lenSep := 0;

	   // zliczamy ilosc znakow do znaku ';'
       while ( Copy( buf, idxSep + lenSep, 1 ) <> ';' )
        and ( Copy( buf, idxSep + lenSep, 1 ) >= ' ' )
         do Inc( lenSep );
      end;

	 // kopiujemy lancuch separatora do wskazanego bufora
     sepLine := '--';
     sepLine := sepLine + Copy( buf, idxSep, lenSep );
     sepLine := sepLine + '--';

     Result := True;
    end;
  end;
end;

function CheckNewMail(logName: String;opType: CountType): Integer;
var
 F: TextFile;
 statBuf: TStatBuf;
 timeBuf: TUTimeBuffer;
 line: String;
 sepStr: String;
 inHeader: boolean;
 markedRead: boolean;
 isMultipart: boolean;
begin
 inHeader := False;
 markedRead := False;
 isMultipart := False;
 timeBuf.actime := 0;
 timeBuf.modtime := 0;

 // najpierw sprawdzamy nazwe naszego pliku poczty
 mailFile := _PATH_MAILDIR + '/' + logName;

 // Odczytujemy informacje o pliku do bufora statbuf.
 // Gdy to sie nie uda, plik nie jest dostepny i automatycznie
 // zwracamy wartosc -1 (blad).
 if stat( PChar(mailFile), statbuf ) <> 0
  then begin
        mailCount := 0;
        newMsgs := 0;
        oldMsgs := 0;
        Result := -1;
        Exit;
       end;

 // Jesli dzialamy w trybie MSG_NOCOUNT, wtedy zglaszamy nowa poczte
 // w oparciu o rozmiar pliku poczty i czas jego modyfikacji.
 if opType = MSG_NOCOUNT
  then begin
        if   ( statbuf.st_size > 0 )
         and ( statbuf.st_size >= lastSize )
         and ( statbuf.st_mtime >= statbuf.st_atime )
         then new_mailCount := 1
         else new_mailCount := 0;

		// Nie zliczamy wiadomosci, wiec po prostu uzyjemy
		// pol jako wartosci logicznych (tj. czy jest poczta,
		// czy tez jej nie ma).
        if statbuf.st_size > 0
         then mailCount := 1
         else mailCount := 0;

        old_mailCount := 0;

		// zapamietujemy rozmiar i czas modyfikacji pliku
        lastSize := statBuf.st_size;
        lastMTime := statBuf.st_mtime;

		// jesli jest nowa poczta, zwracamy 1; w przeciwnym razie
		// zwracamy 0
        if new_mailCount <> 0
         then begin
               Result := 1;
               Exit;
              end
         else begin
               Result := 0;
               Exit;
              end;
       end;

 // Dzialamy w trybie "zliczania". Jezli plik poczty ulegl
 // modyfikacji od ostatniego sprawdzenia, zliczamy ilosc
 // wszystkich i nowych wiadomosci.
 if  ( statBuf.st_mtime <> lastMTime )
  or ( statBuf.st_size <> lastSize )
  then begin
		// Otwieramy plik poczty do odczytu. Jesli to sie nie uda,
		// zwracamy -1 (blad).
        {$I-}
        AssignFile( F, mailFile );
        Reset( F );
        if IOResult <> 0
         then begin
               {$I+}
               Result := -1;
               Exit;
              end;

        mailCount := 0;
        old_mailCount := 0;
		// Odczytujemy linie pliku, tak dlugo jak dlugo sa dostepne.
		// Gdy skoncza sie linie, wychodzimy z petli.
        while not EOF( F ) do
         begin
          Readln( F, line );
		  // Jesli is_multipart ma wartosc True I in_header
		  // ma wartosc False
          if isMultipart and not inHeader
           then begin
				 // Przechodzimy do ostatniej linii
				 // wieloczesciowej wiadomosci
                 if Pos( sepStr, line ) = 1
                  then isMultipart := False;
                end
                // Jesli zas linia jest pusta
				// (pierwszy znak to znak nowej linii)
                else begin
                      if Length( line ) = 0
                       then begin
                             inHeader := False;
                             isInternal := False;
                            end
					   // Jesli zas jestemy w linii From:
					   // (patrz funkcja powyzej)
                       else begin
                             if isFrom( line )
                              then begin
                                    Inc( mailCount );
                                    inHeader := True;
                                    markedRead := False;
                                   end
								   // Jesli zas inHeader ma wartosc True I 
								   // status_is_old (patrz powyzej) zwrocil True I
								   // markedRead ma wartosc False
                                   else begin
                                         if ( inHeader and isOld( line ) and not markedRead)
                                          then begin
                                                Inc( old_mailCount );
                                                markedRead := True;
                                               end
										  // Jesli zas in_header ma wartosc True I
										  // mailstats.is_internal ma wartosc True
                                          else begin
                                                if inHeader and isInternal
                                                 then begin
                                                       if Pos( 'From: Mail System Internal Data', line ) = 1
                                                        then begin
                                                              inHeader := False;
                                                              Dec( mailCount );
                                                              isInternal := False;
                                                             end;
                                                      end
												 // Jesli zas in_header ma wartosc True I
												 // jest to wiadomosc wieloczesiowa
                                                 else if inHeader and isMultipartMsg( line, sepStr )
                                                       then isMultipart := True;
                                               end;
                                        end;
                     end;
                end; { jesli linia jest pusta }
         end; { while }

        // Zamykamy plik, skonczylismy jego przetwarzanie.
        CloseFile( F );
        {$I+}

		// Odtwarzamy znaczniki czasu pliku poczty, tak aby
		// inne programu pocztowe takze dzialaly poprawnie.
        timeBuf.actime := statBuf.st_atime;
        timeBuf.modtime := statBuf.st_mtime;
        utime( PChar(mailFile), @timeBuf );

		// Zapamietaujemy czasy dla nastepnego razu
        lastMtime := statBuf.st_mtime;
        lastSize := statBuf.st_size;

		// Obliczamy ilosc nowych wiadomosci
        new_mailCount := mailCount - old_mailCount;

       end; { if statBuf.st_mtime <> stats.lastMTime }

 Result := new_mailCount;
end;

end.
