// 
// 
// Opis: Prosty odbiornik komunikatow ktory umieszcz
// kazdy otrzymany komunikat w linii obiektu TMemo i
// moze odsylac komunikaty do swojego procesu nadrzednego.
// 
//

unit PipeChild2Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, QTypes, Libc;

type
  TPipeChildMainForm = class(TForm)
    Panel1: TPanel;
    MsgMemo: TMemo;
    Panel2: TPanel;
    ExitBtn: TButton;
    MsgEdit: TEdit;
    SendBtn: TButton;
    procedure ReadPipe;
    procedure FormCreate(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
  private
  public
  end;

const
 StrIndexLen = 4;
 LF = ^J; { linefeed/newline w ASCII  }
   
var
  PipeChildMainForm: TPipeChildMainForm;
  SendPipe : Integer;
  RecvPipe : Integer;
  SigActionRec : TSigAction;

implementation

{$R *.xfm}

procedure Handler(Sig : Integer); cdecl;
begin
 case Sig of
  SIGUSR1 : PipeChildMainForm.ReadPipe;
 end; { case }
end;

procedure InstallHandler;
begin
 with SigActionRec do
  begin
   __sigaction_handler := Handler;
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGUSR1, @SigActionRec, nil);
  end; { with }
end;

procedure TPipeChildMainForm.ReadPipe;
var
 ReadBuf : array[0..BUFSIZ] of Char;
 s : String;
 len : Integer;
begin
 { pobieramy dlugosc lancucha }
 __read(RecvPipe, ReadBuf, StrIndexLen);
 ReadBuf[StrIndexLen] := chr(0);
 len := StrToInt(ReadBuf);

 { pobieramy lancuch }
 __read(RecvPipe, ReadBuf, len);
 ReadBuf[len] := chr(0);
 s := ReadBuf;
 MsgMemo.Lines.Add(s);
end;

procedure TPipeChildMainForm.FormCreate(Sender: TObject);
begin
 InstallHandler;
 RecvPipe := StrToInt(ParamStr(1));
 SendPipe := StrToInt(ParamStr(2));
end;

procedure TPipeChildMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TPipeChildMainForm.SendBtnClick(Sender: TObject);
var
 StrBuf : array[0..BUFSIZ] of Char;
 s : String;
 slen : String;
begin
 s := MsgEdit.Text;
 slen := IntToStr(Length(s));
 while Length(slen) < StrIndexLen do slen := '0' + slen;
 s := slen + s;
 StrPCopy(StrBuf, s);
 __write(SendPipe, StrBuf, Length(s));
 kill(getppid, SIGUSR1);
end;

end.
