//
//
// Opis: Ilustruje uzycie wspolnej pamieci
//
//
unit frmTalk;

interface

uses
  SysUtils, Libc, Types, Classes, Variants, QGraphics, QControls,
  QForms, QDialogs,  QStdCtrls, QTypes, QExtCtrls;

  
const
  AccessMode = S_IREAD or S_IWRITE or S_IRGRP or S_IWGRP;
  BufSize = 508;

type
  PComBuffer = ^TComBuffer;
  TComBuffer = record
    bMsg : boolean;  // ustawiane gdy wiadomosc jest dostepna
    aMsg : Array[0..BufSize] of char;
  end;

const
  SegmentSize = 2*sizeof (TComBuffer);

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Edit1: TEdit;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    FShmId : Integer;
    FOwnShm : boolean;
    FSharePtr : Pointer;
    FSendBuf : PComBuffer;
    FRecvBuf : PComBuffer;
  public
    { Deklaracje publiczne }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  Key : Integer;
begin
  // create key
  Key := ftok (PChar(GetModuleName(0)), 1);

  // probujemy otworzyc istniejaca wspolna pamiec
  FShmId := shmget (Key, 0, 0);
  if FShmId = -1 then
  begin
    // nie istnieje, wiec ja tworzymy
    FShmId := shmget (Key, SegmentSize,
      IPC_CREAT or IPC_EXCL or AccessMode);
    if FShmId = -1 then
      raise Exception.Create (strerror (errno));
    FOwnShm := true;
  end
  else
    FOwnShm := false;

  // dolaczamy wspolna pamiec
  FSharePtr := shmat (FShmId, nil, 0);
  if Integer(FSharePtr) = -1 then
  begin
    FSharePtr := nil;
    raise Exception.Create (strerror (errno));
  end;

  // przygotowujemy bufory
  if FOwnShm then
  begin
    FSendBuf := FSharePtr;
    FRecvBuf := PComBuffer(PChar(FSharePtr) + sizeof (TComBuffer));
    FRecvBuf^.bMsg := false;
  end
  else
  begin
    FRecvBuf := FSharePtr;
    FSendBuf := PComBuffer(PChar(FSharePtr) + sizeof (TComBuffer));
  end;
  FSendBuf^.bMsg := false;
  Timer1.Enabled := true;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Timer1.Enabled := false;
  if Assigned (FSharePtr) then
    shmdt (FSharePtr);
  if FOwnShm then
    if shmctl (FShmId, IPC_RMID, nil) = -1 then
      raise Exception.Create (strerror (errno));
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  s : String;
begin
  // kopiujemy tekst z pola edycji do wspolnej pamieci
  s := Edit1.Text;
  StrCopy (@FSendBuf^.aMsg, PChar(s));
  // ustawiamy znacznik wskazujacy ze widomosc oczekuje
  FSendBuf^.bMsg := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if FRecvBuf^.bMsg then
  begin
    // odczytujemy wiadomosc
    Memo1.Lines.Add (FRecvBuf^.aMsg);
    // po czym zerujemy znacznik
    FRecvBuf^.bMsg := false;
  end;
end;

end.
