//
//
// Opis: Ilustruje uzycie semaforow do synchronizowania programow
//
//
unit frmOnce;

interface

uses
  SysUtils, Libc, Types, Classes, Variants, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls,
  SemFuncs;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    FSemID : Integer;
    FOwnSems : boolean;
    procedure DoActivity (mm: TMemo; sem: Integer);
  public
    { Deklaracje publiczne }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

const
  AccessMode = S_IREAD or S_IWRITE or S_IRGRP or S_IWGRP;

procedure TForm1.FormCreate(Sender: TObject);
var
  Key : Integer;
begin
  Key := ftok (PChar(GetModuleName (0)), 1);
  // prbujemy stworzy nowy zestaw semaforw
  FSemID := semget (Key, 2, IPC_CREAT or IPC_EXCL or AccessMode);
  if FSemID = -1 then
  begin
    // tworzenie sie nie powiodlo, probujemy otworzyc...
    FOwnSems := false;
    FSemID := semget (Key, 0, 0);
    if FSemID = -1 then
      raise Exception.Create (strerror (errno));
  end
  else
  begin
    // stworzono semafory...ustawiamy wartosci
    FOwnSems := true;
    SemSetValue (FSemID, 0, 1);
    SemSetValue (FSemID, 1, 1);
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if FOwnSems then
    SemRemoveSet (FSemid);
end;

function SetScreenCursor (cur: TCursor): TCursor;
begin
  Result := Screen.Cursor;
  Screen.Cursor := cur;
end;

procedure TForm1.DoActivity (mm: TMemo; sem: Integer);
var
  curSave : TCursor;
begin
  curSave := SetScreenCursor (crHourGlass);
  try
    mm.Clear;
    mm.Lines.Add (Format ('Blokowanie semafora dla Czynnosci %d', [sem+1]));
    SemDoOp (FSemID, sem, -1, SEM_UNDO);
    try
      mm.Lines.Add (Format ('Semafor %d zablokowany', [sem]));
      mm.Lines.Add ('Pauza przez 5 sekund...');
      __sleep (5);
      mm.Lines.Add ('gotowe');
    finally
      SemDoOp (FSemID, sem, 1, SEM_UNDO);
    end;
  finally
    SetScreenCursor (curSave);
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  DoActivity (Memo1, 0);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  DoActivity (Memo2, 1);
end;

end.
