// 
// 
// Opis: Prosty nadajnik wiadomosci umieszczajacy
// komunikaty w potoku, odbierane przez oczekujacy
// proces potomny.
// 
//

unit PipeParentMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc;

type
  TPipeParentMainForm = class(TForm)
    Panel1: TPanel;
    MsgEdit: TEdit;
    SendBtn: TButton;
    Panel2: TPanel;
    ExitBtn: TButton;
    Label1: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 StrIndexLen = 4;
 LF = ^J; { linefeed/newline w ASCII }
   
var
  PipeParentMainForm: TPipeParentMainForm;
  SigActionRec : TSigAction;
  PipeOpen : Boolean;
  ParentPipe : TPipeDescriptors;
  PReadDesStr : String;
  ChildPID : pid_t;
  ChildDone : Boolean;

implementation

{$R *.xfm}

procedure Handler(Sig : Integer); cdecl;
begin
 case Sig of
  SIGCHLD : ChildDone := waitpid(ChildPID, nil, WNOHANG) = ChildPID;
 end; { case }
end;

procedure InstallHandler;
begin
 with SigActionRec do
  begin
   __sigaction_handler := Handler;
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGCHLD, @SigActionRec, nil);
  end; { with }
end;

procedure LaunchChild;
var
 i : Integer;
 FName : String;
 HomeDir : String;
 open_max : Integer;
begin
 ChildDone := True;
 PReadDesStr := IntToStr(ParentPipe.ReadDes);
 HomeDir := getenv('HOME') + '/';
 FName := HomeDir + 'PipeChild';
 if not FileExists(FName)
  then begin
        MessageDlg('Blad', 'Nie moge znalezc pliku ' + FName + '.' + LF
         + 'Upewnij sie ze wystepuje on w twojej' + LF
         + 'domowej kartotece.',
         mtError, [mbOK], 0);
        Exit;
       end;

 ChildPID := fork;
 case ChildPID of
  -1 : { to wciaz proces nadrzedny }
       MessageDlg('Blad', 'Nie moge uruchomic procesu potomnego.',
        mtError, [mbOK], 0);

   0 : begin { to jest proces potomny }
        { zamykamy otwarte pliki }
        open_max := sysconf(_SC_OPEN_MAX);
        for i := stderr + 1 to open_max - 1 do
         if (i <> ParentPipe.ReadDes) and (i <> ParentPipe.WriteDes)
          then fcntl(i, F_SETFD, FD_CLOEXEC);

        execlp(PChar(FName), PChar(FName), PReadDesStr, nil);

        { w przypadku bledu opuszczamy proces potomny }
        __exit(EXIT_FAILURE);
       end;
  else ChildDone := False; 
 end { case }
end;

procedure TPipeParentMainForm.ExitBtnClick(Sender: TObject);
begin
 if not ChildDone then kill(ChildPID, SIGTERM);
 Close;
end;

procedure TPipeParentMainForm.FormCreate(Sender: TObject);
begin
 InstallHandler;
 PipeOpen := pipe(ParentPipe) = 0;
 if PipeOpen then LaunchChild;
end;

procedure TPipeParentMainForm.FormActivate(Sender: TObject);
begin
 if PipeOpen then Label1.Caption := '[ Potok jest otwarty ]';
end;

procedure TPipeParentMainForm.SendBtnClick(Sender: TObject);
var
 StrBuf : array[0..BUFSIZ] of Char;
 s : String;
 slen : String;
begin
 if PipeOpen
  then begin
        s := MsgEdit.Text;
        slen := IntToStr(Length(s));
        while Length(slen) < StrIndexLen do slen := '0' + slen;
        s := slen + s;
        StrPCopy(StrBuf, s);
        __write(ParentPipe.WriteDes, StrBuf, Length(s));
        kill(ChildPID, SIGUSR1);
       end;
end;

end.
