// 
// 
// Opis: Wysyla obszerny blok znakow do wskazanego
// potoku FIFO.
// 
//

unit FIFOSendMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc, QComCtrls, QTypes;

type
  TFIFOSendForm = class(TForm)
    ExitBtn: TButton;
    Panel1: TPanel;
    SendBtn: TButton;
    StatusBar: TStatusBar;
    SendMonitor: TTimer;
    procedure SendIt;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
    procedure SendMonitorTimer(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 MIN_BYTES_TO_SEND = 10000000; { 10 milionow }
 FIFO_Name = '/tmp/FIFODEMO_FIFO';

var
  FIFOSendForm: TFIFOSendForm;
  FIFOOpen : Boolean;

implementation

{$R *.xfm}

procedure CreateFIFOIfNecessary;
begin
 FIFOOpen := access(FIFO_Name, F_OK) = 0;
 if not FIFOOpen
  then FIFOOpen := mkfifo(FIFO_Name, 511) = 0; { osemkowo 777 }
end;

procedure TFIFOSendForm.SendIt;
var
 FileDesc : Integer;
 BytesSent : Integer;
 TotalBytesSent : Longint;
 Buf : array[0..BUFSIZ] of char;
begin
  FileDesc := open(FIFO_Name, O_WRONLY);
  if FileDesc <> -1
   then begin
         TotalBytesSent := 0;
         while TotalBytesSent < MIN_BYTES_TO_SEND do
          begin
           BytesSent := __write(FileDesc, Buf, BUFSIZ);
           if BytesSent = -1
            then begin
                  MessageDlg('Blad', 'Blad zapisu do potoku FIFO!',
                   mtError, [mbOK], 0);
                  StatusBar.SimpleText := 'Gotowy do wysylania';
                  Exit;
                 end;

           TotalBytesSent := TotalBytesSent + BytesSent;
          end; { while }
         __close(FileDesc);
         StatusBar.SimpleText := IntToStr(TotalBytesSent)
           + ' bajtow wyslanych';
        end
   else begin
         MessageDlg('Blad', 'Niemozliwy dostep do potoku FIFO!', mtError,
          [mbOK], 0);
         StatusBar.SimpleText := 'Niemozliwy dostep do potoku FIFO';
        end;

end;

procedure TFIFOSendForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TFIFOSendForm.FormCreate(Sender: TObject);
begin
 CreateFIFOIfNecessary;
 StatusBar.SimpleText := 'Gotowy do wysylania';
end;

procedure TFIFOSendForm.FormActivate(Sender: TObject);
begin
 if not FIFOOpen
  then begin
        SendBtn.Enabled := False;
        MessageDlg('Blad', 'Potok FIFO nie jest otwarty!',
         mtError, [mbOK], 0);
       end;
end;

procedure TFIFOSendForm.SendBtnClick(Sender: TObject);
begin
 SendBtn.Enabled := False;
 StatusBar.SimpleText := 'Oczekiwanie na wysylanie danych do potoku to FIFO...';
 SendMonitor.Enabled := True;
end;

procedure TFIFOSendForm.SendMonitorTimer(Sender: TObject);
begin
 SendMonitor.Enabled := False;
 SendIt;
end;

end.
