//
//
// Opis: Demonstruje ustawianie wartosci priorytetu dla procesu
//
//
program priTest;

{$APPTYPE CONSOLE}

uses SysUtils, Libc;

var
  forkRslt : __pid_t;
  i,
  LoopCount : integer;
  s : String;
begin
  forkRslt := fork;
  if forkRslt = 0 then
  begin
    s := 'Child';
  end
  else if forkRslt > 0 then
  begin
    s := 'Parent';
    // ustawiamy priorytet procesu potomnego
    if setpriority (PRIO_PROCESS, forkRslt, 10) = -1 then
      perror ('Blad ustawiania priorytetu');
  end
  else
  begin
    perror ('Blad w funkcji fork');
    exit;
  end;

  LoopCount := 0;
  repeat
    WriteLn (Format ('%s=%d', [s, LoopCount]));
    inc (LoopCount);
    // niewielka petla opozniajaca
    for i := 1 to 10000000 do
      ;
  until false;
end.

