//
//             forktest.dpr : Main Program
//
// Opis: Demonstruje tworzenie procesu potomnego
//
program forkTest;

{$APPTYPE CONSOLE}

uses Libc, SysUtils;

var
  forkResult : __pid_t;


procedure DoChildProcess;
const
  ProgramArgs : array [0..2] of PChar = ('ps', '-ef', nil);
begin
  WriteLn ('Proces potomny: identyfikator procesu = ', getpid);
  WriteLn ('Proces potomny: proces nadrzedny = ', getppid);
  sleep (7);
  WriteLn ('Proces potomny: uruchamianie ps');
  execvp ('ps', @ProgramArgs);
  perror ('Proces potomny: Blad uruchomienia programu');
end;

procedure DoParentProcess;
begin
  WriteLn ('Proces nadrzedny: Identyfikator procesu potomnego = ', forkResult);
  sleep (5);
  WriteLn ('Proces nadrzedny: Wyjscie');
end;

begin
  WriteLn ('Proces nadrzedny: Identyfikator procesu = ', getpid);
  forkResult := fork;
  case forkResult of
    -1 : WriteLn ('Blad tworzenia procesu potomnego');
     0 : DoChildProcess
     else
       DoParentProcess;
  end;
end.

