//
//    frmLaunched.pas : Program uruchamiany przez execTest
//
// Opis: Demonstruje uzycie rodziny funkcji execXXX
//
// Written for "Kylix Power Solutions"
// Copyright (c) 2001, Coriolis Group Books
//       Last revised 08 June 2001
//
unit frmLaunched;

interface

uses
  SysUtils, Libc, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls;

type
  TfrmLaunchedMain = class(TForm)
    Label1: TLabel;
    edCmdLine: TEdit;
    lblProcID: TLabel;
    Label2: TLabel;
    mmEnvironment: TMemo;
    btnExit: TButton;
    lblFilename: TLabel;
    edFilename: TEdit;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  end;

var
  frmLaunchedMain: TfrmLaunchedMain;

implementation

{$R *.xfm}

procedure TfrmLaunchedMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmLaunchedMain.FormCreate(Sender: TObject);
var
  i : Integer;
  p : PPChar;
  s : string;
begin
  // wyswietlamy ID procesu
  lblProcID.Caption := Format ('Process ID = %d', [getpid]);

  // oraz nazwe programu.  0 oznacza biezacy modul
  edFilename.Text := GetModuleName (0);

  // wyswietlamy argumenty linii polecenia
  s := ParamStr(0);
  for i := 1 to ParamCount do
    s := s + ' ' + ParamStr(i);
  edCmdLine.Text := s;

  // wyswietlamy srodowisko
  mmEnvironment.Clear;
  p := envp;
  while p^ <> nil do
  begin
    mmEnvironment.Lines.Add (p^);
    inc (p);
  end;
end;

end.
