// 
// 
// Opis: Program demonstracyjny przedstawiajacy graficzny interfejs
// dla demona harmonogramu crontab.
// 
//

unit frmRunScheduled;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QMask, Libc;

type
  TRunScheduledMainForm = class(TForm)
    WriteBtn: TButton;
    ExitBtn: TButton;
    HoursGroup: TGroupBox;
    HoursAddBtn: TButton;
    HoursDelBtn: TButton;
    DOWGroup: TGroupBox;
    MonthGroup: TGroupBox;
    BrowseDlg: TOpenDialog;
    AppNameGroup: TGroupBox;
    AppNameEdit: TEdit;
    BrowseBtn: TButton;
    DOWCB0: TCheckBox;
    DOWCB1: TCheckBox;
    DOWCB2: TCheckBox;
    DOWCB3: TCheckBox;
    DOWCB4: TCheckBox;
    DOWCB5: TCheckBox;
    DOWCB6: TCheckBox;
    MCB1: TCheckBox;
    MCB2: TCheckBox;
    MCB3: TCheckBox;
    MCB4: TCheckBox;
    MCB5: TCheckBox;
    MCB6: TCheckBox;
    MCB7: TCheckBox;
    MCB8: TCheckBox;
    MCB9: TCheckBox;
    MCB10: TCheckBox;
    MCB11: TCheckBox;
    MCB12: TCheckBox;
    HoursListBox: TListBox;
    DOMGroup: TGroupBox;
    DOMAddBtn: TButton;
    DOMDelBtn: TButton;
    AllDOMRB: TRadioButton;
    SelectedDOMRB: TRadioButton;
    DOMListBox: TListBox;
    MinutesGroup: TGroupBox;
    MinsAddBtn: TButton;
    MinsDelBtn: TButton;
    MinsListBox: TListBox;
    ParamEdit: TEdit;
    Label1: TLabel;
    KillBtn: TButton;
    procedure RefreshDOWDisplay;
    procedure UpdateDOWArray;
    procedure RefreshMonthsDisplay;
    procedure UpdateMonthsArray;
    procedure RefreshDOMDisplay;
    procedure WriteCronFile;
    procedure KillCronFile;
    function CreateCronSpec(var Spec : String) : Boolean;
    procedure ExitBtnClick(Sender: TObject);
    procedure BrowseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure WriteBtnClick(Sender: TObject);
    procedure HoursAddBtnClick(Sender: TObject);
    procedure HoursDelBtnClick(Sender: TObject);
    procedure AllDOMRBClick(Sender: TObject);
    procedure SelectedDOMRBClick(Sender: TObject);
    procedure DOMAddBtnClick(Sender: TObject);
    procedure DOMDelBtnClick(Sender: TObject);
    procedure MinsAddBtnClick(Sender: TObject);
    procedure MinsDelBtnClick(Sender: TObject);
    procedure KillBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 NumDOW = 7;
 NumMonths = 12;

var
  RunScheduledMainForm: TRunScheduledMainForm;
  AppFileName : String;
  MonthsBoolArray : array[1..NumMonths] of Boolean;
  DOWBoolArray : array[0..NumDOW - 1] of Boolean;
  AllDaysSelected : Boolean;

implementation

uses add;

{$R *.xfm}

procedure ErrorMessage(msg : String);
begin
 MessageDlg('Error', msg, mtError, [mbOK], 0);
end;

procedure TRunScheduledMainForm.RefreshDOWDisplay;
begin
 DOWCB0.Checked := DOWBoolArray[0];
 DOWCB1.Checked := DOWBoolArray[1];
 DOWCB2.Checked := DOWBoolArray[2];
 DOWCB3.Checked := DOWBoolArray[3];
 DOWCB4.Checked := DOWBoolArray[4];
 DOWCB5.Checked := DOWBoolArray[5];
 DOWCB6.Checked := DOWBoolArray[6];
end;

procedure TRunScheduledMainForm.UpdateDOWArray;
begin
 DOWBoolArray[0] := DOWCB0.Checked;
 DOWBoolArray[1] := DOWCB1.Checked;
 DOWBoolArray[2] := DOWCB2.Checked;
 DOWBoolArray[3] := DOWCB3.Checked;
 DOWBoolArray[4] := DOWCB4.Checked;
 DOWBoolArray[5] := DOWCB5.Checked;
 DOWBoolArray[6] := DOWCB6.Checked;
end;

procedure TRunScheduledMainForm.RefreshMonthsDisplay;
begin
 MCB1.Checked := MonthsBoolArray[1];
 MCB2.Checked := MonthsBoolArray[2];
 MCB3.Checked := MonthsBoolArray[3];
 MCB4.Checked := MonthsBoolArray[4];
 MCB5.Checked := MonthsBoolArray[5];
 MCB6.Checked := MonthsBoolArray[6];
 MCB7.Checked := MonthsBoolArray[7];
 MCB8.Checked := MonthsBoolArray[8];
 MCB9.Checked := MonthsBoolArray[9];
 MCB10.Checked := MonthsBoolArray[10];
 MCB11.Checked := MonthsBoolArray[11];
 MCB12.Checked := MonthsBoolArray[12];
end;


procedure TRunScheduledMainForm.UpdateMonthsArray;
begin
 MonthsBoolArray[1]  := MCB1.Checked;
 MonthsBoolArray[2]  := MCB2.Checked;
 MonthsBoolArray[3]  := MCB3.Checked;
 MonthsBoolArray[4]  := MCB4.Checked;
 MonthsBoolArray[5]  := MCB5.Checked;
 MonthsBoolArray[6]  := MCB6.Checked;
 MonthsBoolArray[7]  := MCB7.Checked;
 MonthsBoolArray[8]  := MCB8.Checked;
 MonthsBoolArray[9]  := MCB9.Checked;
 MonthsBoolArray[10] := MCB10.Checked;
 MonthsBoolArray[11] := MCB11.Checked;
 MonthsBoolArray[12] := MCB12.Checked;
end;

procedure TRunScheduledMainForm.RefreshDOMDisplay;
begin
  if AllDOMRB.Checked
  then begin
        DOMAddBtn.Enabled := False;
        DOMDelBtn.Enabled := False;
        DOMListBox.Enabled := False;
       end
  else begin
        DOMAddBtn.Enabled := True;
        DOMDelBtn.Enabled := True;
        DOMListBox.Enabled := True;
       end;
end;

procedure TRunScheduledMainForm.WriteCronFile;
const
 IOMode = 'r'; { tryb odczytu z potoku (nie uzywany) }
var
 Command : array[0..128] of char;
 CronFile : TextFile;
 CronFileName : array[0..128] of char;
 CronSpec : String;
 F : PIOFile;
 ErrNum : Integer;
begin
 CronSpec := '';
 if CreateCronSpec(CronSpec)
  then begin
        tmpnam(CronFileName);
        StrCopy(Command, 'crontab ');
        StrCat(Command, CronFileName);

        AssignFile(CronFile, CronFileName);
        Rewrite(CronFile);
        Writeln(CronFile, CronSpec);
        CloseFile(CronFile);

        F := popen(Command, IOMode);
        ErrNum := pclose(F);
        if ErrNum <> -1
         then MessageDlg('Sukces', 'Harmonogram zostal '
          +'zapisany', mtInformation, [mbOK], 0)
         else ErrorMessage('Napotkano blad podczas proby '
          + 'zamkniecia potoku dla programu cron');

        DeleteFile(CronFileName); 
       end
  else ErrorMessage('Nie powiodlo sie stworzenie pliku specyfikacji dla programu cron.');
end;

procedure TRunScheduledMainForm.KillCronFile;
const
 IOMode = 'r'; { tryb odczytu potoku (nie uzywany) }
var
 Command : array[0..128] of char;
 F : PIOFile;
 ErrNum : Integer;
begin
 StrCopy(Command, 'crontab -r');
 F := popen(Command, IOMode);
 ErrNum := pclose(F);
 if ErrNum <> -1
 then MessageDlg('Sukces', 'Wszystkie zdarzenia zostaly usuniete z harmonogramu',
          mtInformation, [mbOK], 0)
 else ErrorMessage('Napotkano blad podczas proby '
  + 'zamkniecia potoku dla programu cron');
end;

function TRunScheduledMainForm.CreateCronSpec(var Spec : String) : Boolean;
var
 s : String;
 i : Integer;
 AllChecked : Boolean;
begin
 Result := False;
 Spec := '';
 
 { minuty }
 if MinsListBox.Items.Count = 0
  then begin
        ErrorMessage('Nie podano minut');
        Exit;
       end;

 for i := 0 to MinsListBox.Items.Count - 1 do
  Spec := Spec + MinsListBox.Items[i] + ',';
 if Spec[Length(Spec)] = ',' then Delete(Spec, Length(Spec), 1);
 Spec := Spec + ' ';


 { godziny }
 if HoursListBox.Items.Count = 0
  then begin
        ErrorMessage('Nie podano godzin');
        Exit;
       end;

 for i := 0 to HoursListBox.Items.Count - 1 do
  Spec := Spec + HoursListBox.Items[i] + ',';
 if Spec[Length(Spec)] = ',' then Delete(Spec, Length(Spec), 1);
 Spec := Spec + ' ';

 { dni }
 if AllDaysSelected
  then Spec := Spec + '* '
  else if DOMListBox.Items.Count = 0
        then begin
              ErrorMessage('Nie wybrano dni');
              Exit;
             end
        else begin
              for i := 0 to DOMListBox.Items.Count - 1 do
               Spec := Spec + DOMListBox.Items[i] + ',';
              if Spec[Length(Spec)] = ','
               then Delete(Spec, Length(Spec), 1);
              Spec := Spec + ' ';
             end;

 { miesiace }
 UpdateMonthsArray;
 AllChecked := True;
 for i := 1 to NumMonths do
  AllChecked := AllChecked and MonthsBoolArray[i];

 if AllChecked
  then Spec := Spec + '*'
  else begin
        for i := 1 to NumMonths do
          if MonthsBoolArray[i] then Spec := Spec + IntToStr(i) + ',';
        if Spec[Length(Spec)] = ','
         then Delete(Spec, Length(Spec), 1);
       end;
  Spec := Spec + ' ';

 { dni tygodnia }
 UpdateDOWArray;
 AllChecked := True;
 for i := 0 to NumDOW - 1 do
  AllChecked := AllChecked and DOWBoolArray[i];

 if AllChecked
  then Spec := Spec + '*'
  else begin
        for i := 0 to NumDOW - 1 do
          if DOWBoolArray[i] then Spec := Spec + IntToStr(i) + ',';
        if Spec[Length(Spec)] = ','
         then Delete(Spec, Length(Spec), 1);
       end;
  Spec := Spec + ' ';     

 { polecenie }
 s := AppNameEdit.Text;
 Spec := Spec + s;
 if not FileExists(s)
  then begin
        ErrorMessage('Bledna nazwa aplikacji');
        Exit;
       end;

 { dodajemy wszystkie parametry }
 if Length(ParamEdit.Text) > 0
  then s := s + ' ' + ParamEdit.Text;
         
 Result := True;
end;
 
procedure TRunScheduledMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TRunScheduledMainForm.BrowseBtnClick(Sender: TObject);
begin
 with BrowseDlg do
  begin
   if Length(InitialDir) = 0 then InitialDir := '~';
 if Execute
  then begin
        if Length(Filename) > 0
         then begin
               AppFileName := FileName;
               AppNameEdit.Text := AppFileName;
              end; 
       end;
  end; { with }
end;

procedure TRunScheduledMainForm.FormCreate(Sender: TObject);
var
 i : Integer;
begin
 AllDaysSelected := True;
 AllDOMRB.Checked := True;

 for i := 1 to NumDOW do
  DOWBoolArray[i - 1] := True;

 for i := 1 to NumMonths do
  MonthsBoolArray[i] := True;
end;

procedure TRunScheduledMainForm.FormActivate(Sender: TObject);
begin
 RefreshDOWDisplay;
 RefreshMonthsDisplay;
 RefreshDOMDisplay;
end;

procedure TRunScheduledMainForm.WriteBtnClick(Sender: TObject);
begin
 WriteCronFile;
end;

procedure TRunScheduledMainForm.HoursAddBtnClick(Sender: TObject);
var
 i : Integer;
 s : String;
 value : Integer;
begin
 AddForm := TAddForm.Create(RunScheduledMainForm);
 AddForm.AddLabel.Caption := 'Wpisz godzine (0-23)';
 if AddForm.ShowModal = mrOK
  then with HoursListBox do
   begin
    s := AddForm.AddEdit.Text;
    if Length(s) = 0 then Exit;
    value := StrToInt(s);
    if (value >= 0) and (value <= 23)
     then begin
           if Items.Count = 0
            then Items.Add(s)
            else if Items.IndexOf(s) = -1 { bez powielania }
                  then begin
                        if value > StrToInt(Items[Items.Count - 1])
                         then begin
                               Items.Append(s)
                              end
                         else begin
                               if value < StrToInt(Items[0])
                                then begin
                                      Items.Insert(0, s)
                                     end
                                else begin
                                      for i := 1 to Items.Count - 1 do
                                       begin
                                        if value < StrToInt(Items[i])
                                         then begin
                                               Items.Insert(i, s);
                                               break;
                                              end;
                                       end; { for }
                                     end;
                              end;
                       end;
          end
     else begin
           ErrorMessage('Godzina poza zakresem (0-23)');
          end;
   end; { with }
 AddForm.Free;
end;

procedure TRunScheduledMainForm.HoursDelBtnClick(Sender: TObject);
begin
 with HoursListBox do
  begin
   if (Items.Count > 0) and (ItemIndex >= 0)
    then begin
          if MessageDlg('Delete Hour', 'Delete the selected hour ('
           + Items[ItemIndex] + ') ?', mtConfirmation, [mbOK], 0)
            = mrOK
             then Items.Delete(ItemIndex);
         end;
  end; { with }
end;

procedure TRunScheduledMainForm.AllDOMRBClick(Sender: TObject);
begin
 SelectedDOMRB.Checked := not AllDOMRB.Checked;
 AllDaysSelected := AllDOMRB.Checked;
 RefreshDOMDisplay;
end;

procedure TRunScheduledMainForm.SelectedDOMRBClick(Sender: TObject);
begin
 AllDOMRB.Checked := not SelectedDOMRB.Checked;
 AllDaysSelected := AllDOMRB.Checked;
 RefreshDOMDisplay;
end;

procedure TRunScheduledMainForm.DOMAddBtnClick(Sender: TObject);
var
 i : Integer;
 s : String;
 value : Integer;
begin
 AddForm := TAddForm.Create(RunScheduledMainForm);
 AddForm.AddLabel.Caption := 'Wpisz dzien (1-31)';
 if AddForm.ShowModal = mrOK
  then with DOMListBox do
   begin
    s := AddForm.AddEdit.Text;
    if Length(s) = 0 then Exit;
    value := StrToInt(s);
    if (value > 0 ) and (value < 32)
     then begin
           if Items.Count = 0
            then Items.Add(s)
            else if Items.IndexOf(s) = -1 { bez powielania }
                  then begin
                        if value > StrToInt(Items[Items.Count - 1])
                         then begin
                               Items.Append(s)
                              end
                         else begin
                               if value < StrToInt(Items[0])
                                then begin
                                      Items.Insert(0, s)
                                     end
                                else begin
                                      for i := 1 to Items.Count - 1 do
                                       begin
                                        if value < StrToInt(Items[i])
                                         then begin
                                               Items.Insert(i, s);
                                               break;
                                              end;
                                       end; { for }
                                     end;
                              end;
                       end;
          end
     else begin
           ErrorMessage('Dzien poza zakresem (1-31)');
          end;
   end; { with }
 AddForm.Free;

end;

procedure TRunScheduledMainForm.DOMDelBtnClick(Sender: TObject);
begin
 with DOMListBox do
  begin
   if (Items.Count > 0) and (ItemIndex >= 0)
    then begin
          if MessageDlg('Delete Day', 'Delete the selected day ('
           + Items[ItemIndex] + ') ?', mtConfirmation, [mbOK], 0)
            = mrOK
             then Items.Delete(ItemIndex);
         end;
  end; { with }
end;

procedure TRunScheduledMainForm.MinsAddBtnClick(Sender: TObject);
var
 i : Integer;
 s : String;
 value : Integer;
begin
 AddForm := TAddForm.Create(RunScheduledMainForm);
 AddForm.AddLabel.Caption := 'Wpisz minuty (0-59)';
 if AddForm.ShowModal = mrOK
  then with MinsListBox do
   begin
    s := AddForm.AddEdit.Text;
    if Length(s) = 0 then Exit;
    value := StrToInt(s);
    if (value >= 0) and (value <= 59)
     then begin
           if Items.Count = 0
            then Items.Add(s)
            else if Items.IndexOf(s) = -1 { bez powielania }
                  then begin
                        if value > StrToInt(Items[Items.Count - 1])
                         then begin
                               Items.Append(s)
                              end
                         else begin
                               if value < StrToInt(Items[0])
                                then begin
                                      Items.Insert(0, s)
                                     end
                                else begin
                                      for i := 1 to Items.Count - 1 do
                                       begin
                                        if value < StrToInt(Items[i])
                                         then begin
                                               Items.Insert(i, s);
                                               break;
                                              end;
                                       end; { for }
                                     end;
                              end;
                       end;
          end
     else begin
           ErrorMessage('Minuty poza zakresem (0-59)');
          end;
   end; { with }
 AddForm.Free;

end;

procedure TRunScheduledMainForm.MinsDelBtnClick(Sender: TObject);
begin
 with MinsListBox do
  begin
   if (Items.Count > 0) and (ItemIndex >= 0)
    then begin
          if MessageDlg('Usuwanie minut', 'Usunac zaznaczone '
           + 'minuty ('
           + Items[ItemIndex] + ') ?', mtConfirmation, [mbOK], 0)
            = mrOK
             then Items.Delete(ItemIndex);
         end;
  end; { with }

end;

procedure TRunScheduledMainForm.KillBtnClick(Sender: TObject);
begin
 if MessageDlg('Czyszczenie harmonogramu', 'Usunac z harmonogramu wszystkie zdarzenia '
    + 'dla biezacego uzytkownika?', mtConfirmation, [mbYes, mbNo], 0)
    = mrYes
  then KillCronFile;
end;

end.

