// 
// 
// Opis: Program demonstracyjny ilustrujacy sposob ograniczenia
// procesu do pojedynczego egzemplarza.
// 
//

program OneInst;

uses
  QForms,
  SysUtils,
  Libc,
  QDialogs,
  ProcStuff in 'ProcStuff.pas',
  frmOneInst in 'frmOneInst.pas' {OneInstMainForm};

const
 HOME_DIR : PChar = 'HOME';
 BaseLockFileName = '.oneinst.LCK';

var
 AlreadyRunning : Boolean;
 PID : Integer; { identyfikator tego procesu }
 ProcStatus : String;
 UserName : String;
 CmdLine : String;
 LockPIDStr : String;
 LockFile : TextFile;
 HomeDirPtr : PChar;
 HomeDirName : String;
 LockFileName : String;

{$R *.res}

begin
  AlreadyRunning := False;
  CmdLine := '';
  PID := getpid;
  HomeDirPtr := getenv(HOME_DIR);
  HomeDirName := StrPas(HomeDirPtr);
  LockFileName := HomeDirName + '/' + BaseLockFileName;

  if FileExists(LockFileName)
   then begin
         { sprawdzamy poprawnosc pliku }
         AssignFile(LockFile, LockFileName);
         Reset(LockFile);
         readln(LockFile, LockPIDStr);
         CloseFile(LockFile);

         { czy oryginalny proces wciaz dziala -- i czy
           jest to ta sama aplikacja? }
         if GetProcessStatus(StrToInt(LockPIDStr),
              ProcStatus, UserName, CmdLine)
             = NO_ERR
          then begin { Proces istnieje. Czy jest procesem zombie? }
                if pos('Z', ProcStatus) = 0
                 then begin
                       { Proces dziala -- i nie jest zombie. Ale
                         czy jest to *ta* aplikacja? }
                       if ExtractFileName(CmdLine) =
                          ExtractFileName(Application.ExeName)
                        then begin
                              AlreadyRunning := True;
                              MessageDlg('Przpraszam!', 'Przepraszam. W danej '
                                + 'chwili moze dzialac tylko '
                                + 'jeden egzemplarz tego programu.',
                                mtError, [mbOK], 0);
                             end;
                      end;
               end;
        end;

  if not AlreadyRunning
   then begin
         { tworzymy plik blokujacy }
         if FileExists(LockFileName) then DeleteFile(LockFileName);
         AssignFile(LockFile, LockFileName);
         Rewrite(LockFile);
         writeln(LockFile, IntToStr(PID));
         CloseFile(LockFile);

         Application.Initialize;
         Application.CreateForm(TOneInstMainForm, OneInstMainForm);
         Application.Run;

         { porzadkujemy }
         if FileExists(LockFileName) then DeleteFile(LockFileName);
        end;
end.
