// 
// 
// Opis: Odczytuje i wyswietla informacje
// o biezacym procesie i uzytkowniku.
// 
//

unit frmGetPID;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs, Libc,
  QStdCtrls;

type
  TGetPIDMainForm = class(TForm)
    InfoMemo: TMemo;
    InfoBtn: TButton;
    ExitBtn: TButton;
    Label1: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure InfoBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

var
  GetPIDMainForm: TGetPIDMainForm;

implementation

{$R *.xfm}

procedure TGetPIDMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TGetPIDMainForm.InfoBtnClick(Sender: TObject);
var
 p       : PChar;
 PPWRec  : PPasswordRecord;
 pid     : Integer;
 uid     : Integer;
 ppid    : Integer;
 pgroup  : Integer;
 ppgroup : Integer;
begin
 pid := getpid;
 uid := getuid;
 ppid := getppid;
 pgroup := getpgrp;
 ppgroup := getpgid(ppid);
 PPWRec := getpwuid(uid);
 p := PPWRec^.pw_name;

 with InfoMemo.Lines do
  begin
   Clear;
   Add(' Informacje o uzytkowniku:');
   Add('   Nazwa logowania: ' + p);
   Add('   Identyfikator uzytkownika: ' + IntToStr(uid));
   Add('');
   Add(' Biezacy proces:');
   Add('   Identyfikator procesu: ' + IntToStr(pid));
   Add('   Identyfikator grupy:   ' + IntToStr(pgroup));
   Add('');
   Add(' proces nadrzedny dla biezacego procesu:');
   Add('   Identyfikator procesu: ' + IntToStr(ppid));
   Add('   Identyfikator grupy:   ' + IntToStr(ppgroup));
  end; { with }
end;

end.
