// 
// 
// Opis: Sprawdza czy w skrzynce oczekuje nowa poczta.
// 
//

unit CheckMailMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls,
  QForms, QDialogs, CheckMailStuff, QStdCtrls, Libc, QExtCtrls;

type
  TCheckMailForm = class(TForm)
    ExitBtn: TButton;
    CheckBtn: TButton;
    GroupBox1: TGroupBox;
    UserNameLabel: TLabel;
    NoCountRB: TRadioButton;
    CountRB: TRadioButton;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

var
  CheckMailForm: TCheckMailForm;
  UserName: String;

implementation

{$R *.xfm}

procedure TCheckMailForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TCheckMailForm.FormCreate(Sender: TObject);
var
 PPWRec  : PPasswordRecord;
 uid     : Integer;
begin
 uid := getuid;
 PPWRec := getpwuid(uid);
 UserName := PPWRec^.pw_name;
 UserNameLabel.Caption := 'Sprawdzanie poczty dla: ' +    UserName;
end;

procedure TCheckMailForm.CheckBtnClick(Sender: TObject);
var
 QtyNewMail: Integer;
 Result : Integer;
begin
 if NoCountRB.Checked
  then begin
        Result := CheckNewMail(UserName, MSG_NOCOUNT);
        case Result of
          0 : ShowMessage('Nie ma nowej poczty.');
          1 : ShowMessage('Masz nowa poczte.');
         -1 : ShowMessage('Wystapil blad podczas sprawdzania poczty!');
        end; { case }
       end
  else begin
        QtyNewMail := CheckNewMail(UserName, MSG_COUNT);
        if QtyNewMail <> -1
         then ShowMessage('Uzytkownik ' + UserName + ' ma '
               + IntToStr(QtyNewMail) + ' nowych wiadomosci.')
         else ShowMessage('Wystapil blad podczas sprawdzania poczty!');
       end;
end;

end.
