//
//
// Opis: Demonstruje uzycie pomocy online
//
//
unit frmTOC;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls,
  frmHelpTopic;

type
  TfrmshTOC = class(TForm)
    btnDisplay: TButton;
    btnCancel: TButton;
    lbTopics: TListBox;
    procedure btnDisplayClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FlstHelp: TStringList;
  end;

var
  frmshTOC: TfrmshTOC;

procedure ShowTOC (const sFilename: String; lstHelp: TStringList);
procedure ShutDown;

implementation


{$R *.xfm}
procedure ShowTOC (const sFilename: String; lstHelp: TStringList);
var
  i: Integer;
  lstLine: TStringList;
begin
  if not Assigned (frmshTOC) then
    frmshTOC := TfrmshTOC.Create (nil);

  {
	Tworzymy kopie listy pliku pomocy, tak aby modyfikacja
	plikow pomocy nie wprowadzila zamieszania do naszej listy tematow.
  }
  frmshTOC.FlstHelp.Assign (lstHelp);
  frmshTOC.Caption := Format ('Spis tresci dla %s', [sFileName]);

  frmshTOC.lbTopics.Clear;
  lstLine := TStringList.Create;
  try
    for i := 0 to lstHelp.Count-1 do
    begin
      lstLine.CommaText := lstHelp[i];
      if lstLine.Count >= 3 then
        frmshTOC.lbTopics.Items.Add (lstLine[1]);
    end;
    frmshTOC.lbTopics.ItemIndex := 0;
  finally
    lstLine.Free;
  end;

  frmshTOC.Show;
end;

procedure ShutDown;
begin
  if Assigned(frmshTOC) then
    FreeAndNil (frmshTOC);
end;

procedure TfrmshTOC.btnDisplayClick(Sender: TObject);
var
  lstLine: TStringList;
begin
  if lbTopics.ItemIndex <> -1 then
  begin
    lstLine := TStringList.Create;
    try
      lstLine.CommaText := FlstHelp[lbTopics.ItemIndex];
      frmHelpTopic.ShowTopic (lstLine[1], lstLine[2]);
      Hide;
    finally
      lstLine.Free;
    end;
  end;
end;

procedure TfrmshTOC.FormCreate(Sender: TObject);
begin
  FlstHelp := TStringList.Create;
end;

procedure TfrmshTOC.FormDestroy(Sender: TObject);
begin
  FlstHelp.Free;
end;


end.
