// 
// 
// Opis: Ustawia uprawnienia dla wskazanego pliku.
// 
//

unit SetPerms;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc, IdGlobal;

type
  TfrmPermissions = class(TForm)
	fileDlg: TOpenDialog;
	btnBrowse: TButton;
	GroupBox1: TGroupBox;
	GroupBox2: TGroupBox;
    cbUserRead: TCheckBox;
    cbUserWrite: TCheckBox;
    cbUserExecute: TCheckBox;
	cbGroupRead: TCheckBox;
	cbGroupWrite: TCheckBox;
	cbGroupExecute: TCheckBox;
	GroupBox3: TGroupBox;
    cbAllRead: TCheckBox;
    cbAllWrite: TCheckBox;
    cbAllExecute: TCheckBox;
	tbFileName: TEdit;
	Label1: TLabel;
	GroupBox4: TGroupBox;
	cbSetUID: TCheckBox;
	cbSetGID: TCheckBox;
	cbSticky: TCheckBox;
	btnUpdate: TButton;
	btnClose: TButton;
	procedure btnBrowseClick(Sender: TObject);
	procedure btnCloseClick(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
  private
	{ Deklaracje prywatne }
	procedure getPermissions;
	procedure updatePermissions;
  public
	{ Deklaracje publiczne }
  end;

var
  frmPermissions: TfrmPermissions;

implementation

{$R *.xfm}

procedure TfrmPermissions.btnBrowseClick(Sender: TObject);
begin
	if ( fileDlg.Execute ) then
		begin
		tbFileName.Text := fileDlg.FileName;
		getPermissions;
		end;
end;


procedure TfrmPermissions.btnUpdateClick(Sender: TObject);
begin
	updatePermissions;
end;


procedure TfrmPermissions.btnCloseClick(Sender: TObject);
begin
	close;
end;


procedure TfrmPermissions.getPermissions;
var
	rv: Integer;
	perms: Cardinal;
	statBuf: TStatBuf;
	filename: String;
begin
	cbSetUID.Checked := false;
	cbSetGID.Checked := false;
	cbSticky.Checked := false;
	cbUserRead.Checked := false;
	cbUserWrite.Checked := false;
	cbUserExecute.Checked := false;
	cbGroupRead.Checked := false;
	cbGroupWrite.Checked := false;
	cbGroupExecute.Checked := false;
	cbAllRead.Checked := false;
	cbAllWrite.Checked := false;
	cbAllExecute.Checked := false;

	filename := tbFileName.Text;
	rv := stat( PChar( filename ), statBuf );
	if ( rv = -1 ) then
		ShowMessage( 'Nie powiodlo sie wywolanie stat dla pliku.' )
	else
		begin
		perms := statBuf.st_mode;

		if ( perms And S_ISUID <> 0 ) then
			cbSetUID.Checked := true;
		if ( perms And S_ISGID <> 0 ) then
			cbSetGID.Checked := true;
		if ( perms And S_ISVTX <> 0 ) then
			cbSticky.Checked := true;
		if ( perms And S_IRUSR <> 0 ) then
			cbUserRead.Checked := true;
		if ( perms And S_IWUSR <> 0 ) then
			cbUserWrite.Checked := true;
		if ( perms And S_IXUSR <> 0 ) then
			cbUserExecute.Checked := true;
		if ( perms And S_IRGRP <> 0 ) then
			cbGroupRead.Checked := true;
		if ( perms And S_IWGRP <> 0 ) then
			cbGroupWrite.Checked := true;
		if ( perms And S_IXGRP <> 0 ) then
			cbGroupExecute.Checked := true;
		if ( perms And S_IROTH <> 0 ) then
			cbAllRead.Checked := true;
		if ( perms And S_IWOTH <> 0 ) then
			cbAllWrite.Checked := true;
		if ( perms And S_IXOTH <> 0 ) then
			cbAllExecute.Checked := true;
		end;
end;


procedure TfrmPermissions.updatePermissions;
var
	perms: Cardinal;
	filename: String;
	rv: Integer;
begin
	filename := tbFileName.Text;
	perms := 0;

	if ( cbSetUID.Checked ) then
		perms := perms Or S_ISUID;
	if ( cbSetGID.Checked ) then
		perms := perms Or S_ISGID;
	if ( cbSticky.Checked ) then
		perms := perms Or S_IRUSR;
	if ( cbUserWrite.Checked ) then
		perms := perms Or S_IWUSR;
	if ( cbUserExecute.Checked ) then
		perms := perms Or S_IXUSR;
	if ( cbGroupRead.Checked ) then
		perms := perms Or S_IRGRP;
	if ( cbGroupWrite.Checked ) then
		perms := perms Or S_IWGRP;
	if ( cbGroupExecute.Checked ) then
		perms := perms Or S_IXGRP;
	if ( cbAllRead.Checked ) then
		perms := perms Or S_IROTH;
	if ( cbAllWrite.Checked ) then
		perms := perms Or S_IWOTH;
	if ( cbAllExecute.Checked ) then
		perms := perms Or S_IXOTH;

	rv := chmod( PChar( filename ), perms );
	if ( rv = -1 ) then
		begin
		ShowMessage( 'Nie powiodlo sie wywolanie chmod dla pliku.' )
		getPermissions;
		end;
end;

end.
