// 
// 
// Opis: Demonstruje funkcje systemowe mount oraz umount.
// 
//

unit TypeSelect;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls;

type
  TTTypeSelect = class(TForm)
   lbFsTypes: TListBox;
   Label1: TLabel;
   Label2: TLabel;
   btnContinue: TButton;
   procedure btnContinueClick(Sender: TObject);
   procedure FormLoaded(Sender: TObject);
  private
  { Deklaracje prywatne }
  public
  { Deklaracje publiczne }
   selectedType: String;
  end;

var
  TTypeSelect: TTTypeSelect;

implementation

{$R *.xfm}

procedure TTTypeSelect.btnContinueClick(Sender: TObject);
begin
 if ( lbFsTypes.ItemIndex = -1 )
  then
   ShowMessage( 'Najpierw wybierz typ systemu pliku.' )
  else
   begin
    selectedType := lbFsTypes.Items.Strings[lbFsTypes.ItemIndex];
    Close;
   end;
end;

procedure TTTypeSelect.FormLoaded(Sender: TObject);
var
 F: TextFile;
 str: String;
begin
 AssignFile( F, '/proc/filesystems' );
 FileMode := fmOpenRead;
 Reset( F );
 Readln( F, str );
 {$I-}
 while ( Length( str ) > 0 ) do
  begin
   str := Trim( str );
   if ( Pos( 'nodev', str ) = 0 )
    then lbFsTypes.Items.Add( str );
   Readln( f, str );
  end;
 CloseFile( F );
 {$I+}
end;

end.
