// 
// 
// Opis: Wyswietla kilka wazniejszych atrybutow
// plikow zawartych we wskazanej kartotece.
// 
//

unit FileList;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc, QButtons;

type
  TForm1 = class(TForm)
	Label1: TLabel;
	tbDirectory: TEdit;
	lbFiles: TListBox;
	Label2: TLabel;
	btnUp: TSpeedButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    lblInode: TLabel;
	lblType: TLabel;
    lblSize: TLabel;
    lblOwner: TLabel;
    lblGroup: TLabel;
    lblModified: TLabel;
	procedure tbDirectoryExit(Sender: TObject);
	procedure FormLoaded(Sender: TObject);
	procedure lbFilesDblClick(Sender: TObject);
	procedure lbFilesClick(Sender: TObject);
	procedure btnUpClick(Sender: TObject);
  private
	{ Deklaracje prywatne }
	procedure populateFileList;
	function constructFilename( directory: String; filename: String ): String; overload;
	function constructFilename: String; overload;
  public
	{ Deklaracje publiczne }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}


procedure TForm1.populateFileList;
var
	searchRec: TSearchRec;
	rv: Integer;
	savedCursor: TCursor;
begin
	savedCursor := Screen.Cursor;
	Screen.Cursor := crHourGlass;

	lbFiles.Clear;

	rv := FindFirst( String( tbDirectory.Text ) + '/*', faAnyFile, searchRec );

	while ( rv = 0 ) do
		begin
		lbFiles.items.Add( searchRec.Name );
		rv := FindNext( searchRec );
		end;

	FindClose( searchrec );

	lbFiles.ClearSelection;

	Screen.Cursor := savedCursor;
end;

function TForm1.constructFilename( directory: String; filename: String ): String;
var
	idx: Integer;
begin
		// specjalny przypadek dla '.'
	if ( filename = '.' ) then
		result := directory

		// specjalny przypadek dla '..'
	else if ( filename = '..' ) then
		begin
			// z lancucha katalogow wydzielamy ostatni katalog
		idx := LastDelimiter( '/', directory ) - 1;
		directory := Copy( directory, 0, idx );
		if ( Length( directory ) = 0 ) then
			directory := '/';
		result := directory;
		end

		// specjalny przypadek dla katalogu glownego
	else if ( directory = '/' ) then
		result := directory + filename

		// zwykly plik
	else
		result := directory + '/' + filename;


end;

function TForm1.constructFilename: String;
var
	idx: Integer;
begin
	idx := lbFiles.ItemIndex;
	result := constructFilename( tbDirectory.text, lbFiles.Items.Strings[idx] );
end;

procedure TForm1.tbDirectoryExit(Sender: TObject);
begin
	populateFileList;
end;

procedure TForm1.FormLoaded(Sender: TObject);
begin
	populateFileList;
end;

procedure TForm1.lbFilesDblClick(Sender: TObject);
var
	rv: Integer;
	filename: String;
	statbuf: TStatBuf;
begin
		// Czy dwukrotnie kliknieta pozycja to katalog?
		// Jesli tak, przechodzimy do tego katalogu
		// i ponownie wypelniamy liste.
	filename := constructFilename;
	rv := lstat( PChar( filename ), statBuf );
	if ( rv = -1 ) then
		begin
		ShowMessage( 'Nie mozna odczytac informacji o pliku.' );
		exit;
		end;

	if ( statBuf.st_mode And S_IFDIR = 0 ) then exit;

	tbDirectory.Text := filename;
	populateFileList;

	lblInode.Caption := '';
	lblType.Caption := '';
	lblSize.Caption := '';
	lblOwner.Caption := '';
	lblGroup.Caption := '';
	lblModified.Caption := '';
end;

procedure TForm1.lbFilesClick(Sender: TObject);
var
	rv: Integer;
	filename: String;
	statbuf: TStatBuf;
	passrec: PPasswordRecord;
	grprec: PGroup;
begin
		// uzyskujemy infromacje o wybranym pliku
		// i wypelniamy formularz
	filename := constructFilename;
	rv := lstat( PChar( filename ), statBuf );
	if ( rv = -1 ) then
		begin
		ShowMessage( 'Nie mozna odczytac informacji o pliku.' );
		exit;
		end;

		// wyswietlamy numer inode pliku
	lblInode.Caption := InttoStr( statBuf.st_ino );

		// wyswietlamy tryb (typ) pliku
	if ( S_ISDIR( statBuf.st_mode) = true ) then
		lblType.Caption := 'Katalog'
	else if ( S_ISCHR( statBuf.st_mode) = true ) then
		lblType.Caption := 'Urzadzenie znakowe'
	else if ( S_ISBLK( statBuf.st_mode) = true ) then
		lblType.Caption := 'Urzadzenie blokowe'
	else if ( S_ISREG( statBuf.st_mode) = true ) then
		lblType.Caption := 'Zwykly plik'
	else if ( S_ISFIFO( statBuf.st_mode) = true ) then
		lblType.Caption := 'FIFO'
	else if ( S_ISLNK( statBuf.st_mode) = true ) then
		lblType.Caption := 'Lacze symboliczne'
	else if ( S_ISSOCK( statBuf.st_mode ) = true ) then
		lblType.Caption := 'Gniazdo'
	else
		lblType.Caption := 'Nieznany...';

		// wyswietlamy rozmiar pliku
	lblSize.Caption := IntToStr( statBuf.st_size );

		// wyswietlamy wlasciciela pliku
	passrec := getpwuid( statBuf.st_uid );
	lblOwner.Caption := passrec.pw_name;

		// wyswietlamy grupe wlasciciela pliku
	grprec := getgrgid( statBuf.st_gid );
	lblGroup.caption := grprec.gr_name;

		// wyswietlamy czas ostatniej modyfikacji pliku
	lblModified.Caption := ctime( Addr( statBuf.st_mtime ) );
end;

procedure TForm1.btnUpClick(Sender: TObject);
begin
	tbDirectory.Text := constructFilename( tbDirectory.text, '..' );
	populateFileList;
end;

end.
