// 
// 
// Opis: Prosty nadajnik komunikatow, ktory umieszcza
// komunikaty w potoku dla oczekujacego procesu potomnego
// i moze odbierac komunikaty wysylane przez proces potomny.
// 
//

unit PipeParent2Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc;

type
  TPipeParentMainForm = class(TForm)
    Panel1: TPanel;
    MsgEdit: TEdit;
    SendBtn: TButton;
    Panel2: TPanel;
    ExitBtn: TButton;
    Label1: TLabel;
    MsgMemo: TMemo;
    procedure ReadPipe;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
  private
  public
  end;

const
 StrIndexLen = 4;
 LF = ^J; { linefeed/newline w ASCII  }

var
  PipeParentMainForm: TPipeParentMainForm;
  SigActionRec : TSigAction;
  PipeOpen : Boolean;
  ParentSendPipe : TPipeDescriptors;
  ParentRecvPipe : TPipeDescriptors;
  PReadDesStr : String;
  PWriteDesStr : String;
  ChildPID : pid_t;
  ChildDone : Boolean;

implementation

{$R *.xfm}

procedure Handler(Sig : Integer); cdecl;
begin
 case Sig of
  SIGCHLD : ChildDone := waitpid(ChildPID, nil, WNOHANG) = ChildPID;
  SIGUSR1 : PipeParentMainForm.ReadPipe;
 end; { case }
end;

procedure InstallHandler;
begin
 with SigActionRec do
  begin
   __sigaction_handler := Handler;
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGCHLD, @SigActionRec, nil);
   sigaction(SIGUSR1, @SigActionRec, nil);
  end; { with }
end;

procedure LaunchChild;
var
 i : Integer;
 FName : String;
 HomeDir : String;
 open_max : Integer;
begin
 ChildDone := True;
 PReadDesStr := IntToStr(ParentSendPipe.ReadDes);
 PWriteDesStr := IntToStr(ParentRecvPipe.WriteDes);
 HomeDir := getenv('HOME') + '/';
 FName := HomeDir + 'PipeChild2';
 if not FileExists(FName)
  then begin
        MessageDlg('Blad', 'Nie moge zlokalizowac pliku ' + FName + '.' + LF
         + 'Upewnij sie ze wystepuje on w ' + LF
         + 'twojej domowej kartotece.',
         mtError, [mbOK], 0);
        Exit;
       end;

 ChildPID := fork;
 case ChildPID of
  -1 : { To jest wciaz proces nadrzedny }
       MessageDlg('Blad', 'Nie moge uruchomic procesu potomnego.',
        mtError, [mbOK], 0);

   0 : begin { To jest proces potomny }
        { Zamykamy otwarte pliki }
        open_max := sysconf(_SC_OPEN_MAX);
        for i := stderr + 1 to open_max - 1 do
         if   (i <> ParentSendPipe.ReadDes)
          and (i <> ParentSendPipe.WriteDes)
          and (i <> ParentRecvPipe.ReadDes)
          and (i <> ParentRecvPipe.WriteDes)
          then fcntl(i, F_SETFD, FD_CLOEXEC);

        execlp(PChar(FName), PChar(FName), PReadDesStr, PWriteDesStr, nil);

        { Jesli execlp sie nie powidlo, wtedy zamykamy proces potomny }
        __exit(EXIT_FAILURE);
       end;
  else ChildDone := False; 
 end { case }
end;

procedure TPipeParentMainForm.ExitBtnClick(Sender: TObject);
begin
 if not ChildDone then kill(ChildPID, SIGTERM);
 Close;
end;

procedure TPipeParentMainForm.FormCreate(Sender: TObject);
begin
 InstallHandler;
 PipeOpen := (pipe(ParentSendPipe) = 0) and (pipe(ParentRecvPipe) = 0);
 if PipeOpen then LaunchChild;
end;

procedure TPipeParentMainForm.FormActivate(Sender: TObject);
begin
 if PipeOpen then Label1.Caption := '[ Potoki sa otwarte ]';
end;

procedure TPipeParentMainForm.SendBtnClick(Sender: TObject);
var
 StrBuf : array[0..BUFSIZ] of Char;
 s : String;
 slen : String;
begin
 if PipeOpen
  then begin
        s := MsgEdit.Text;
        slen := IntToStr(Length(s));
        while Length(slen) < StrIndexLen do slen := '0' + slen;
        s := slen + s;
        StrPCopy(StrBuf, s);
        __write(ParentSendPipe.WriteDes, StrBuf, Length(s));
        kill(ChildPID, SIGUSR1);
       end;
end;

procedure TPipeParentMainForm.ReadPipe;
var
 ReadBuf : array[0..BUFSIZ] of Char;
 s : String;
 len : Integer;
begin
 { pobieramy dlugosc lancucha }
 __read(ParentRecvPipe.ReadDes, ReadBuf, StrIndexLen);
 ReadBuf[StrIndexLen] := chr(0);
 len := StrToInt(ReadBuf);

 { pobieramy lancuch }
 __read(ParentRecvPipe.ReadDes, ReadBuf, len);
 ReadBuf[len] := chr(0);
 s := ReadBuf;
 MsgMemo.Lines.Add(s);
end;


end.
