// 
// 
// Opis: Demonstruje uzycie funkcji bibliotecznej kill
// jako oglnego transmitera sygnalow.
// 
//

unit SigSendMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, ProcStuff, Libc;

type
  TSigSendMainForm = class(TForm)
    ExitBtn: TButton;
    SigRBGroup: TRadioGroup;
    SendBtn: TButton;
    ShutdownXBtn: TButton;
    procedure ExitBtnClick(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
    procedure ShutdownXBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF = ^J; { linefeed/newline w ASCII}  
var
  SigSendMainForm: TSigSendMainForm;

implementation

{$R *.xfm}

procedure TSigSendMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TSigSendMainForm.SendBtnClick(Sender: TObject);
var
 i : Integer;
 ErrResult : Integer;
 SigValue : Integer;
 L : TList;
 PRec : PProcInfoRec;
begin
 ErrResult := 0;
 SigValue := -1;

 { wyznaczamy wartosc sygnalu do wyslania }
 case SigRBGroup.ItemIndex of
  0 : SigValue := SIGINT;
  1 : SigValue := SIGCHLD;
  2 : SigValue := SIGUSR1;
 end; { case }

 { uzyskujemy informacje o procesie CrashTestDummy o ile dziala }
 L := GetProcessListByName('CrashTestDummy');
 if L.Count > 0
  then for i := 0 to L.Count - 1 do
   begin
    PRec := L.Items[i];
    with PRec^ do
     begin
      if MessageDlg('Wysylanie sygnalu',
        'Proces ' + IntToStr(i + 1) + ' z ' + IntToStr(L.Count)
         + LF + LF
         + 'Wyslac do tego procesu?' + LF + LF
         + 'Process ID: ' + IntToStr(PID) + LF,
         mtConfirmation, [mbYes, mbNo], 0) = mrYes
       then ErrResult := kill(PID, SigValue);
       if ErrResult <> 0
        then MessageDlg('Blad', 'Nie mozna wykonac tej '
          + 'operacji!', mtError, [mbOK], 0);

     end; { with }
   end { for }
  else MessageDlg('Blad', 'Program CrashTestDummy nie dziala',
        mtError, [mbOK], 0);
 L.Free;
end;

procedure TSigSendMainForm.ShutdownXBtnClick(Sender: TObject);
var
 L : TList;
 PRec : PProcInfoRec;
 ErrResult : Integer;
begin
 ErrResult := 0;
 if (getuid = 0) { root }
  then begin
        MessageDlg('Blad', 'Mowilismy przeciez abys nie '
		+ 'uruchamial tego jako "root"',
         mtError, [mbOK], 0);
        Exit;
       end;

 { uzyskujemy informacje o procesie X Window }
 L := GetProcessListByName('X');
 if L.Count > 0
  then begin
        PRec := L.Items[0];
        with PRec^ do
         begin
          if MessageDlg('Wysylanie sygnalu',
              'Wyslac do tego procesu?' + LF + LF
              + 'Process ID: ' + IntToStr(PID) + LF,
              mtConfirmation, [mbYes, mbNo], 0) = mrYes
           then ErrResult := kill(PID, SIGTERM);
           if ErrResult <> 0
	        then MessageDlg('Blad', 'Nie mozna wykonac tej '
		      + 'operacji!', mtError, [mbOK], 0);
         end; { with }
       end
  else MessageDlg('Blad', 'X Windows nie dziala',
        mtError, [mbOK], 0);
 L.Free;
end;

end.
