// 
// 
// Opis: Wyswietla nazwe wybranego sygnalu w systemie.
// 
//

unit SigNamesMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc;

type
  TSigNamesForm = class(TForm)
    ExitBtn: TButton;
    Label2: TLabel;
    NamePanel: TPanel;
    SigValCombo: TComboBox;
    Label1: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SigValComboClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

var
  SigNamesForm: TSigNamesForm;

implementation

{$R *.xfm}

procedure TSigNamesForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TSigNamesForm.FormCreate(Sender: TObject);
var
 i : Integer;
begin
 for i := 1 to NSIG - 1 do
  SigValCombo.Items.Add(IntToStr(i));
end;

procedure TSigNamesForm.SigValComboClick(Sender: TObject);
var
 SigVal : Integer;
begin
 SigVal := -1;
 NamePanel.Caption := '';
 if SigValCombo.ItemIndex >= 0
  then begin
        try
         SigVal := SigValCombo.ItemIndex + 1;
        except
         on Exception do MessageDlg('Blad', 'Niedozwolona wartosc.',
             mtError, [mbOK], 0);
        end; { try }

        if (SigVal >= 0) and (SigVal < NSIG)
         then NamePanel.Caption := ' ' + strsignal(SigVal)
         else MessageDlg('Blad', 'Wartosc sygnalu poza zakresem', mtError,
                 [mbOK], 0);
       end;
end;

end.
