// 
// 
// Opis: Prosty nadajnik wysylajacy trzy
// rozne sygnaly systemowe.
// 
//

unit HndSendMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, ProcStuff, Libc;

type
  THndSenderForm = class(TForm)
    ExitBtn: TButton;
    GroupBox1: TGroupBox;
    GreenBtn: TButton;
    RedBtn: TButton;
    IntBtn: TButton;
    procedure ExitBtnClick(Sender: TObject);
    procedure GreenBtnClick(Sender: TObject);
    procedure RedBtnClick(Sender: TObject);
    procedure IntBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF = ^J; { linefeed/newline w ASCII}  
var
  HndSenderForm: THndSenderForm;

implementation

{$R *.xfm}

function SendCommand(ProcName : String;
                     SigValue : Integer) : Boolean;
var
 i : Integer;
 L : TList;
 PRec : PProcInfoRec;
 ErrResult : Integer;
begin
 ErrResult := 0;

 { uzyskujemy informacje o procesie o ile dziala }
 L := GetProcessListByName(ProcName);
 if L.Count > 0
  then for i := 0 to L.Count - 1 do
   begin
    PRec := L.Items[i];
    with PRec^ do
     begin
      if MessageDlg('Wysylanie sygnalu',
        'Proces ' + IntToStr(i + 1) + ' z ' + IntToStr(L.Count)
         + LF + LF
         + 'Wyslac do tego procesu?' + LF + LF
         + 'Process ID: ' + IntToStr(PID) + LF,
         mtConfirmation, [mbYes, mbNo], 0) = mrYes
       then ErrResult := kill(PID, SigValue);
       if ErrResult <> 0
         then MessageDlg('Blad', 'Nie mozna wykonac tej '
           + 'operacji!', mtError, [mbOK], 0);

     end; { with }
   end { for }
  else begin
        ErrResult := -1;
        MessageDlg('Blad', ProcName + ' nie dziala',
        mtError, [mbOK], 0);
       end;

 L.Free;
 Result := ErrResult = 0;
end;

procedure THndSenderForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure THndSenderForm.GreenBtnClick(Sender: TObject);
begin
 SendCommand('HndRecvr', SIGUSR1);
end;

procedure THndSenderForm.RedBtnClick(Sender: TObject);
begin
 SendCommand('HndRecvr', SIGUSR2);
end;

procedure THndSenderForm.IntBtnClick(Sender: TObject);
begin
 SendCommand('HndRecvr', SIGINT);
end;

end.
