// 
// 
// Opis: Przykladowy odbiornik obslugujacy
// trzy rozne sygnaly systmowe.
// 
//

unit HndRecvrMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QExtCtrls, QStdCtrls, Libc, QTypes;

type
  THndRecvrForm = class(TForm)
    ExitBtn: TButton;
    ColorPanel: TPanel;
    Label1: TLabel;
    BlockIntCB: TCheckBox;
    StatusLabel: TLabel;
    MonitorTimer: TTimer;
    BehaviorRBGroup: TRadioGroup;
    procedure RefreshForm;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BlockIntCBClick(Sender: TObject);
    procedure MonitorTimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BehaviorRBGroupClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

var
  HndRecvrForm: THndRecvrForm;
  SigActionRec: TSigAction;
implementation

{$R *.xfm}

procedure Handler(Sig : Integer); cdecl;
begin
 case Sig of
  SIGUSR1 : HndRecvrForm.ColorPanel.Color := clGreen;
  SIGUSR2 : HndRecvrForm.ColorPanel.Color := clRed;
  SIGINT  : ShowMessage('Otrzymano przerwanie Ctrl-C!');
 end; { case }
end;

procedure InstallHandlers;
begin
 with SigActionRec do
  begin
   __sigaction_handler := Handler;
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGUSR1, @SigActionRec, nil);
   sigaction(SIGUSR2, @SigActionRec, nil);
   sigaction(SIGINT, @SigActionRec, nil);
  end; { with }
end;

procedure DefaultHandlers;
begin
 with SigActionRec do
  begin
   __sigaction_handler := TSigActionHandler(SIG_DFL);
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGUSR1, @SigActionRec, nil);
   sigaction(SIGUSR2, @SigActionRec, nil);
   sigaction(SIGINT, @SigActionRec, nil);
  end; { with }
end;

procedure IgnoreHandlers;
begin
 with SigActionRec do
  begin
   __sigaction_handler := TSigActionHandler(SIG_IGN);
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGUSR1, @SigActionRec, nil);
   sigaction(SIGUSR2, @SigActionRec, nil);
   sigaction(SIGINT, @SigActionRec, nil);
  end; { with }
end;

procedure THndRecvrForm.RefreshForm;
begin
 case BehaviorRBGroup.ItemIndex of
  0 : InstallHandlers;
  1 : DefaultHandlers;
  2 : IgnoreHandlers;
 end; { case }
end;

procedure THndRecvrForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure THndRecvrForm.FormActivate(Sender: TObject);
begin
 Label1.Caption := 'Process ID: ' + IntToStr(getpid);
end;

procedure THndRecvrForm.BlockIntCBClick(Sender: TObject);
var
 ProcMask : sigset_t;
begin
 sigemptyset(ProcMask);
 sigaddset(ProcMask, SIGINT);
 if BlockIntCB.Checked
  then sigprocmask(SIG_BLOCK, @ProcMask, nil)
  else sigprocmask(SIG_UNBLOCK, @ProcMask, nil);
end;

procedure THndRecvrForm.MonitorTimerTimer(Sender: TObject);
var
 PendingMask : sigset_t;
begin
 sigpending(PendingMask);
 if sigismember(PendingMask, SIGINT) <> 0
  then StatusLabel.Caption := '(Oczekuje przerwanie)'
  else StatusLabel.Caption := '';
end;

procedure THndRecvrForm.FormCreate(Sender: TObject);
begin
 RefreshForm;
end;

procedure THndRecvrForm.BehaviorRBGroupClick(Sender: TObject);
begin
 RefreshForm;
end;

end.
