//
//
// Opis: Ilustruje uzycie semaforow do synchronizowania programow
//
//
unit SemFuncs;

interface

uses SysUtils, Libc;

type
  TSemUnion = record
    case integer of
      0: (val: Integer);                // warto dla SETVAL
      1: (buf: PSemaphoreIDDescriptor); // bufor dla IPC_STAT i IPC_SET
      2: (ary: PWord);                  // tablica dla GETALL i SETALL
      3: (__buf: PSemphoreInfo);        // bufor dla IPC_INFO
  end;

procedure SemRemoveSet (semid: Integer);
procedure SemSetValue (semid, semnum, aVal: Integer);
function  SemGetValue (semid, semnum: Integer): Integer;
function  SemGetStat (semid: Integer): TSemaphoreIDDescriptor;
procedure SemSetStat (semid: Integer; const ds: TSemaphoreIDDescriptor);
function  SemGetNumSems (semid: Integer): Integer;
function  SemGetAccessMode (semid: Integer): Integer;
procedure SemSetAccessMode (semid, aMode: Integer);

function  SemDoOp (semid, semnum, op, flags: Integer): boolean;

implementation

procedure SemRemoveSet (semid: Integer);
begin
  if semctl (semid, 0, IPC_RMID) = -1 then
    raise Exception.Create (strerror (errno));
end;

procedure SemSetValue (semid, semnum, aVal: Integer);
var
  arg: TSemUnion;
begin
  arg.val := aVal;
  if semctl (semid, semnum, SETVAL, arg) = -1 then
    raise Exception.Create (strerror (errno));
end;

function  SemGetValue (semid, semnum: Integer): Integer;
begin
  Result := semctl (semid, semnum, GETVAL);
  if Result = -1 then
    raise Exception.Create (strerror (errno));
end;

function SemGetStat (semid: Integer): TSemaphoreIDDescriptor;
var
  ds: TSemaphoreIDDescriptor;
  arg: TSemUnion;
begin
  arg.buf := @ds;
  if semctl (semid, 0, IPC_STAT, arg) = -1 then
    raise Exception.Create (strerror (errno));
  Result := ds;
end;

procedure SemSetStat (semid: Integer; const ds: TSemaphoreIDDescriptor);
var
  arg: TSemUnion;
begin
  arg.buf := @ds;
  if semctl (semid, 0, IPC_SET, arg) = -1 then
    raise Exception.Create (strerror (errno));
end;

function  SemGetNumSems (semid: Integer): Integer;
begin
  Result := SemGetStat (semid).sem_nsems;
end;

function  SemGetAccessMode (semid: Integer): Integer;
begin
  Result := SemGetStat (semid).sem_perm.mode;
end;

procedure SemSetAccessMode (semid, aMode: Integer);
var
  ds : TSemaphoreIDDescriptor;
begin
  ds := SemGetStat (semid);
  ds.sem_perm.mode := aMode;
  SemSetStat (semid, ds);
end;

function  SemDoOp (semid, semnum, op, flags: Integer): boolean;
var
  buf : TSemaphoreBuffer;
begin
  buf.sem_num := semnum;
  buf.sem_op := op;
  buf.sem_flg := flags;
  if semop (semid, @buf, 1) = -1 then
    if (errno = EINTR) or (errno = EAGAIN) then
      Result := false
    else
      raise Exception.Create (strerror (errno))
  else
    Result := true;
end;

end.

