// 
// 
// Opis: Demonstracja laczenia potoku
// pomiedzy procesem GUI a procesem konsoli.
// 
//

unit PipeReadMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc;

type
  TPipeReadMainForm = class(TForm)
    RunPSBtn: TButton;
    ExitBtn: TButton;
    psMemo: TMemo;
    ParamCombo: TComboBox;
    Label1: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure RunPSBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

var
  PipeReadMainForm: TPipeReadMainForm;

implementation

{$R *.xfm}

procedure TPipeReadMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TPipeReadMainForm.RunPSBtnClick(Sender: TObject);
const
 LF = ^J; { linefeed/newline w ASCII }
 READ_IOMode = 'r'; { tryb odczytu z potoku }
var
 CmdArr : array[0..512] of char;
 StrArr : array[0..1024] of char;
 F : PIOFile;
 pPipeStr : Pointer;
 s : String;
begin
 psMemo.Clear;

 { przygotowujemy uruchomienie polecenia ps }
 StrCopy(CmdArr, 'ps');

 if ParamCombo.ItemIndex > 0
  then begin
        { dodajemy wybrany parametr }
        s := ' ' + ParamCombo.Items[ParamCombo.ItemIndex];
        StrPCopy(StrArr, s);
        StrCat(CmdArr, StrArr);
       end;

{ otwieramy potok do odczytu danych wyjsciowych programu ps }
 F := popen(CmdArr, READ_IOMode);
 if assigned(F)
  then begin
        repeat
         { odczytujemy pelna linie z potoku wyjsciowego polecenia ps }
         pPipeStr := fgets(StrArr, 1024, F);
         if Assigned(pPipeStr)
          then begin
                s := StrPas(pPipeStr);
                if pos(LF, s) > 0 then delete(s, pos(LF, s), 1);
                psMemo.Lines.Add(s);
               end;
        until not Assigned(pPipeStr);
        { zamykamy potok - nie probujemy wylapac bledow }
        pclose(F);
       end;
end;

end.
